/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.RectangularNode;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class EllipticalNode
extends RectangularNode {
    @Override
    public Point2D getConnectionPoint(Direction d) {
        Rectangle2D bounds = this.getBounds();
        double a = bounds.getWidth() / 2.0;
        double b = bounds.getHeight() / 2.0;
        double x = d.getX();
        double y = d.getY();
        double cx = bounds.getCenterX();
        double cy = bounds.getCenterY();
        if (a != 0.0 && b != 0.0 && (x != 0.0 || y != 0.0)) {
            double t = Math.sqrt(x * x / (a * a) + y * y / (b * b));
            return new Point2D.Double(cx + x / t, cy + y / t);
        }
        return new Point2D.Double(cx, cy);
    }

    @Override
    public Shape getShape() {
        return new Ellipse2D.Double(this.getBounds().getX(), this.getBounds().getY(), this.getBounds().getWidth() - 1.0, this.getBounds().getHeight() - 1.0);
    }
}

