/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.util.UniqueIDGenerator;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractEdge
implements Edge {
    private Node start;
    private Node end;
    private String id;
    private Integer revision = new Integer(0);

    public AbstractEdge() {
        this.id = UniqueIDGenerator.getNewId();
    }

    @Override
    public void connect(Node s, Node e) {
        this.start = s;
        this.end = e;
    }

    @Override
    public Node getStart() {
        return this.start;
    }

    @Override
    public Node getEnd() {
        return this.end;
    }

    @Override
    public Rectangle2D getBounds(Graphics2D g2) {
        Line2D conn = this.getConnectionPoints();
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(conn.getX1(), conn.getY1(), conn.getX2(), conn.getY2());
        return r;
    }

    @Override
    public Line2D getConnectionPoints() {
        Rectangle2D startBounds = this.start.getBounds();
        Rectangle2D endBounds = this.end.getBounds();
        Point2D.Double startCenter = new Point2D.Double(startBounds.getCenterX(), startBounds.getCenterY());
        Point2D.Double endCenter = new Point2D.Double(endBounds.getCenterX(), endBounds.getCenterY());
        Direction toEnd = new Direction(startCenter, endCenter);
        return new Line2D.Double(this.start.getConnectionPoint(toEnd), this.end.getConnectionPoint(toEnd.turn(180.0)));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AbstractEdge clone() {
        try {
            AbstractEdge cloned = (AbstractEdge)super.clone();
            cloned.id = UniqueIDGenerator.getNewId();
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public Integer getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(Integer newRevisionNumber) {
        this.revision = newRevisionNumber;
    }

    @Override
    public void incrementRevision() {
        int i = this.revision;
        this.revision = new Integer(++i);
    }
}

