/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.eclipseplugin.wizards;

import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.GraphService;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public abstract class NewWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection = null;
    private WizardNewFileCreationPage creationPage = null;
    private String pageTitle;
    private Graph UMLGraph;

    public boolean performFinish() {
        String fname = this.creationPage.getFileName();
        if (!fname.toLowerCase().endsWith(this.getFileExtension())) {
            this.creationPage.setFileName(fname + this.getFileExtension());
        }
        if (this.creationPage.getErrorMessage() != null) {
            return false;
        }
        final IFile file = this.creationPage.createNewFile();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    NewWizard.this.doFinish(file, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.creationPage = new WizardNewFileCreationPage(this.getPageTitle(), this.selection);
        this.creationPage.setTitle(this.getPageTitle());
        this.creationPage.setDescription("Enter file name.");
        this.addPage((IWizardPage)this.creationPage);
    }

    private String getPageTitle() {
        if (this.pageTitle == null) {
            this.pageTitle = "New UML Class Diagram";
        }
        return this.pageTitle;
    }

    public void setPageTitle(String title) {
        this.pageTitle = title;
    }

    private Graph getUMLGraph() {
        if (this.UMLGraph == null) {
            this.UMLGraph = new ClassDiagramGraph();
        }
        return this.UMLGraph;
    }

    public void setUMLGraph(Graph graph) {
        this.UMLGraph = graph;
    }

    private void doFinish(final IFile file, IProgressMonitor monitor) throws CoreException {
        try {
            Graph graph = this.getUMLGraph();
            ByteBuffer buffer = GraphService.serializeGraph(graph);
            ByteArrayInputStream bis = new ByteArrayInputStream(buffer.array());
            file.setContents((InputStream)bis, true, true, monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.horstmann.violet.eclipseplugin.editors.UMLEditor", (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    public abstract String getFileExtension();
}

