/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.resources;

import com.aptana.ide.server.http.HttpContentTypes;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.resources.IHttpResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileHttpResource
implements IHttpResource {
    private File _file;

    public FileHttpResource(File file) {
        this._file = file;
    }

    public InputStream getContentInputStream(HttpServer server) {
        try {
            return new FileInputStream(this._file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public long getContentLength() {
        return this._file.length();
    }

    public String getContentType() {
        String result = null;
        int fileExtIndex = this._file.getName().lastIndexOf(46);
        if (fileExtIndex != -1) {
            String fileExtension = this._file.getName().substring(fileExtIndex);
            result = HttpContentTypes.getContentType(fileExtension);
        }
        if (result == null) {
            result = "text/plain";
        }
        return result;
    }
}

