/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.utils;

import com.aptana.ide.editors.unified.utils.SubstitutionTextReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

class HTML2TextReader
extends SubstitutionTextReader {
    private static final String EMPTY_STRING = "";
    private static final Map<String, String> fgEntityLookup;
    private static final Set<String> fgTags;
    private int fCounter = 0;
    private TextPresentation fTextPresentation;
    private int fBold = 0;
    private int fItalic = 0;
    private int fHeader = 0;
    private int fCode = 0;
    private int fPre = 0;
    private int fStartOffset = -1;
    private int fStartItalicOffset = -1;
    private int fStartHeaderOffset = -1;
    private int fStartCodeOffset = -1;
    private int fStartPreOffset = -1;
    private boolean fIsPreformattedText = false;
    private String fPreviousTag = "";
    private Color fLinkColor = null;
    private Color fPreColor = null;

    static {
        fgTags = new HashSet<String>();
        fgTags.add("b");
        fgTags.add("i");
        fgTags.add("br");
        fgTags.add("h2");
        fgTags.add("h3");
        fgTags.add("h5");
        fgTags.add("p");
        fgTags.add("dl");
        fgTags.add("dt");
        fgTags.add("dd");
        fgTags.add("li");
        fgTags.add("ul");
        fgTags.add("pre");
        fgTags.add("code");
        fgTags.add("script");
        fgTags.add("property");
        fgTags.add("var");
        fgTags.add("method");
        fgTags.add("specification");
        fgEntityLookup = new HashMap<String, String>(8);
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
        fgEntityLookup.put("rarr", "?");
    }

    public HTML2TextReader(Reader reader, TextPresentation presentation, Display display) {
        super(new PushbackReader(reader));
        this.fTextPresentation = presentation;
        RGB blackColor = new RGB(0, 0, 0);
        RGB linkColor = new RGB(93, 117, 215);
        RGB preColor = new RGB(204, 153, 51);
        ColorRegistry cm = JFaceResources.getColorRegistry();
        cm.put("black", blackColor);
        cm.put("link", linkColor);
        cm.put("pre", preColor);
        this.fLinkColor = cm.get("link");
        this.fPreColor = cm.get("pre");
    }

    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            ++this.fCounter;
        }
        return c;
    }

    protected void startBold() {
        if (this.fBold == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fBold;
    }

    protected void startItalic() {
        if (this.fItalic == 0) {
            this.fStartItalicOffset = this.fCounter;
        }
        ++this.fItalic;
    }

    protected void startHeader() {
        if (this.fHeader == 0) {
            this.fStartHeaderOffset = this.fCounter;
        }
        ++this.fHeader;
    }

    protected void startCode() {
        if (this.fCode == 0) {
            this.fStartCodeOffset = this.fCounter;
        }
        ++this.fCode;
    }

    protected void startPre() {
        if (this.fPre == 0) {
            this.fStartPreOffset = this.fCounter;
        }
        ++this.fPre;
    }

    protected void startPreformattedText() {
        this.fIsPreformattedText = true;
        this.setSkipWhitespace(false);
    }

    protected void stopPreformattedText() {
        this.fIsPreformattedText = false;
        this.setSkipWhitespace(true);
    }

    protected void stopBold() {
        --this.fBold;
        if (this.fBold == 0) {
            if (this.fTextPresentation != null) {
                this.fTextPresentation.addStyleRange(new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, null, 1));
            }
            this.fStartOffset = -1;
        }
    }

    protected void stopItalic() {
        --this.fItalic;
        if (this.fItalic == 0) {
            if (this.fTextPresentation != null) {
                this.fTextPresentation.addStyleRange(new StyleRange(this.fStartItalicOffset, this.fCounter - this.fStartItalicOffset, null, null, 2));
            }
            this.fStartItalicOffset = -1;
        }
    }

    protected void stopHeader() {
        --this.fHeader;
        if (this.fHeader == 0) {
            if (this.fTextPresentation != null) {
                this.fTextPresentation.addStyleRange(new StyleRange(this.fStartHeaderOffset, this.fCounter - this.fStartHeaderOffset, null, null, 1));
            }
            this.fStartHeaderOffset = -1;
        }
    }

    protected void stopCode() {
        --this.fCode;
        if (this.fHeader == 0) {
            if (this.fTextPresentation != null) {
                this.fTextPresentation.addStyleRange(new StyleRange(this.fStartCodeOffset, this.fCounter - this.fStartCodeOffset, this.fLinkColor, null, 1));
            }
            this.fStartCodeOffset = -1;
        }
    }

    protected void stopPre() {
        --this.fPre;
        if (this.fPre == 0) {
            if (this.fTextPresentation != null) {
                this.fTextPresentation.addStyleRange(new StyleRange(this.fStartPreOffset, this.fCounter - this.fStartPreOffset, this.fPreColor, null, 0));
            }
            this.fStartCodeOffset = -1;
        }
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 60) {
            return this.processHTMLTag();
        }
        if (c == 38) {
            return this.processEntity();
        }
        if (this.fIsPreformattedText) {
            return this.processPreformattedText(c);
        }
        return null;
    }

    private String html2Text(String html) {
        if (html == null || html.length() == 0) {
            return EMPTY_STRING;
        }
        String tag = html;
        String lastTag = this.fPreviousTag;
        this.fPreviousTag = tag;
        if ('/' == tag.charAt(0)) {
            tag = tag.substring(1);
        }
        if (!fgTags.contains(tag)) {
            return EMPTY_STRING;
        }
        if ("pre".equals(html)) {
            this.startPreformattedText();
            this.startPre();
            return LINE_DELIM;
        }
        if ("/pre".equals(html)) {
            this.stopPreformattedText();
            this.stopPre();
            return LINE_DELIM;
        }
        if ("script".equals(html)) {
            return "<script>";
        }
        if ("/script".equals(html)) {
            return "</script>";
        }
        if (this.fIsPreformattedText) {
            return EMPTY_STRING;
        }
        if ("b".equals(html)) {
            this.startBold();
            return EMPTY_STRING;
        }
        if ("code".equals(html) || "property".equals(html) || "var".equals(html) || "method".equals(html) || "specification".equals(html)) {
            this.startCode();
            return EMPTY_STRING;
        }
        if ("i".equals(html)) {
            this.startItalic();
            return EMPTY_STRING;
        }
        if ("h5".equals(html) || "dt".equals(html)) {
            this.startBold();
            return EMPTY_STRING;
        }
        if ("h2".equals(html)) {
            this.startBold();
            if ("/p".equals(lastTag) || "/pre".equals(lastTag)) {
                return LINE_DELIM;
            }
            return String.valueOf(LINE_DELIM) + LINE_DELIM;
        }
        if ("h3".equals(html)) {
            this.startHeader();
            if ("/p".equals(lastTag) || "/pre".equals(lastTag)) {
                return LINE_DELIM;
            }
            return String.valueOf(LINE_DELIM) + LINE_DELIM;
        }
        if ("dl".equals(html)) {
            return LINE_DELIM;
        }
        if ("dd".equals(html)) {
            return "\t";
        }
        if ("li".equals(html)) {
            return String.valueOf(LINE_DELIM) + "\t";
        }
        if ("/b".equals(html)) {
            this.stopBold();
            return EMPTY_STRING;
        }
        if ("/code".equals(html) || "/property".equals(html) || "/var".equals(html) || "/method".equals(html) || "/specification".equals(html)) {
            this.stopCode();
            return EMPTY_STRING;
        }
        if ("/i".equals(html)) {
            this.stopItalic();
            return EMPTY_STRING;
        }
        if ("p".equals(html)) {
            return LINE_DELIM;
        }
        if ("br".equals(html)) {
            return LINE_DELIM;
        }
        if ("/p".equals(html)) {
            if ("/pre".equals(lastTag)) {
                return EMPTY_STRING;
            }
            return LINE_DELIM;
        }
        if ("/h5".equals(html) || "/dt".equals(html)) {
            this.stopBold();
            return LINE_DELIM;
        }
        if ("/h2".equals(html)) {
            this.stopBold();
            return LINE_DELIM;
        }
        if ("/h3".equals(html)) {
            this.stopHeader();
            return EMPTY_STRING;
        }
        if ("/dd".equals(html)) {
            return LINE_DELIM;
        }
        return EMPTY_STRING;
    }

    private String processHTMLTag() throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch = this.nextChar();
            while (ch != -1 && ch != 62) {
                buf.append(Character.toLowerCase((char)ch));
                ch = this.nextChar();
                if (ch == 34) {
                    buf.append(Character.toLowerCase((char)ch));
                    ch = this.nextChar();
                    while (ch != -1 && ch != 34) {
                        buf.append(Character.toLowerCase((char)ch));
                        ch = this.nextChar();
                    }
                }
                if (ch != 60) continue;
                this.unread(ch);
                return String.valueOf('<') + buf.toString();
            }
            if (ch == -1) {
                return null;
            }
            int tagLen = buf.length();
            if (tagLen < 3 || !"!--".equals(buf.substring(0, 3)) || tagLen >= 5 && "--".equals(buf.substring(tagLen - 2))) break;
            buf.append(ch);
        }
        return this.html2Text(buf.toString());
    }

    private String processPreformattedText(int c) {
        if ((c == 13 || c == 10) && LINE_DELIM.length() == 2) {
            ++this.fCounter;
        }
        return null;
    }

    private void unread(int ch) throws IOException {
        ((PushbackReader)this.getReader()).unread(ch);
    }

    protected String entity2Text(String symbol) {
        if (symbol.length() > 1 && symbol.charAt(0) == '#') {
            try {
                int ch = symbol.charAt(1) == 'x' ? Integer.parseInt(symbol.substring(2), 16) : Integer.parseInt(symbol.substring(1), 10);
                return EMPTY_STRING + (char)ch;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String str = fgEntityLookup.get(symbol);
            if (str != null) {
                return str;
            }
        }
        return "&" + symbol;
    }

    private String processEntity() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextChar();
        while (Character.isLetterOrDigit((char)ch) || ch == 35) {
            buf.append((char)ch);
            ch = this.nextChar();
        }
        if (ch == 59) {
            return this.entity2Text(buf.toString());
        }
        buf.insert(0, '&');
        if (ch != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

