/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.preferences;

import com.aptana.ide.intro.preferences.FeatureDescriptor;
import com.aptana.ide.update.FeatureUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureRegistry {
    private static List<FeatureDescriptor> fgFeatures;

    private FeatureRegistry() {
    }

    public static List<FeatureDescriptor> getRequiredFeatures() {
        if (fgFeatures == null) {
            ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.aptana.ide.intro", "requiredFeatures");
            int i = 0;
            while (i < elements.length) {
                String featureId = elements[i].getAttribute("id");
                String name = elements[i].getAttribute("label");
                String url = elements[i].getAttribute("url");
                IConfigurationElement[] children = elements[i].getChildren("conflictsWith");
                ArrayList<String> conflicts = new ArrayList<String>();
                int j = 0;
                while (j < children.length) {
                    IConfigurationElement configurationElement = children[j];
                    String con = configurationElement.getAttribute("featureId");
                    conflicts.add(con);
                    ++j;
                }
                list.add(new FeatureDescriptor(featureId, name, url, conflicts.toArray(new String[0])));
                ++i;
            }
            fgFeatures = list;
        }
        return fgFeatures;
    }

    public static List<FeatureDescriptor> gatherUninstalledRequiredFeatures() {
        ArrayList<FeatureDescriptor> uninstalledFeatures = new ArrayList<FeatureDescriptor>();
        List<FeatureDescriptor> features = FeatureRegistry.getRequiredFeatures();
        for (FeatureDescriptor descriptor : features) {
            if (FeatureUtil.isInstalled((String)descriptor.getId())) continue;
            uninstalledFeatures.add(descriptor);
        }
        return uninstalledFeatures;
    }

    public static List<FeatureDescriptor> gatherInstalledRequiredFeatures() {
        ArrayList<FeatureDescriptor> installedFeatures = new ArrayList<FeatureDescriptor>();
        List<FeatureDescriptor> features = FeatureRegistry.getRequiredFeatures();
        for (FeatureDescriptor descriptor : features) {
            if (!FeatureUtil.isInstalled((String)descriptor.getId())) continue;
            installedFeatures.add(descriptor);
        }
        return installedFeatures;
    }

    public static boolean isFeatureIgnored(String featureId, String[] featureList) {
        if (featureList == null) {
            return false;
        }
        int i = 0;
        while (i < featureList.length) {
            String string = featureList[i];
            if (string.equals(featureId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean doesFeatureConflict(FeatureDescriptor featureId, String[] installedFeatureList) {
        List<String> installed = Arrays.asList(installedFeatureList);
        String[] conflicts = featureId.getConflicts();
        if (conflicts == null) {
            return false;
        }
        int i = 0;
        while (i < conflicts.length) {
            String string = conflicts[i];
            if (installed.contains(string)) {
                return true;
            }
            Bundle bundle = Platform.getBundle((String)string);
            if (bundle != null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

