/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.online.OnlineDetectionService;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.PerspectiveManager;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.ActionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinPluginPulldown;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ShowMyAptanaAction
implements IWorkbenchWindowPulldownDelegate2 {
    private static final String CACHED_IMAGE = "cached_intro_image";
    private static final String LOCAL_IMAGE_LOCATION = "/icons/aptana_home.png";
    private static final int DAY = 86400000;
    private IWorkbenchWindow window;
    private Menu toolbarMenu = null;
    private ToolItem toolItem;
    private ImageLoader loader;
    private ImageData[] imageData;
    private Thread animateThread;
    private Image[] image;
    private long lastChecked;
    private boolean animationRunning;

    public Menu getMenu(Control parent) {
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
        }
        this.toolbarMenu = new Menu(parent);
        this.buildMenu(this.toolbarMenu);
        return this.toolbarMenu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.buildMenu(menu);
        return menu;
    }

    public void dispose() {
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
            this.toolbarMenu = null;
        }
        this.toolItem = null;
        this.animateThread = null;
        if (this.image != null) {
            int i = 0;
            while (i < this.image.length) {
                this.image[i].dispose();
                ++i;
            }
        }
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        if (this.animationRunning) {
            this.animationRunning = false;
        }
        ShowMyAptanaAction.openEditor();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (action == null || !(action instanceof WWinPluginPulldown)) {
            return;
        }
        if (this.toolItem == null) {
            IContributionItem[] items;
            CoolBarManager manager = ((WorkbenchWindow)this.window).getCoolBarManager();
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof IToolBarContributionItem) {
                    IContributionItem[] children;
                    IToolBarContributionItem toolbarItem = (IToolBarContributionItem)item;
                    IContributionItem[] iContributionItemArray2 = children = toolbarItem.getToolBarManager().getItems();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IContributionItem child = iContributionItemArray2[n4];
                        String id = child.getId();
                        if (id != null && id.equals(action.getId())) {
                            ActionContributionItem actionItem = (ActionContributionItem)child;
                            this.toolItem = (ToolItem)actionItem.getWidget();
                            if (this.toolItem != null) {
                                File file = this.getLocalImageFile();
                                if (file.exists()) {
                                    this.setDefaultImage(file.getPath());
                                    break;
                                }
                                this.setDefaultImage(IntroPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.intro.INTRO_TOOLBAR_DEFAULT_IMAGE"));
                                break;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if (this.toolItem == null || !this.haventCheckedInADay()) {
            return;
        }
        this.lastChecked = System.currentTimeMillis();
        if (!this.isRemoteImageUpdated()) {
            return;
        }
        this.loadImage();
        this.toolItem.setImage(this.image[0]);
        this.updateCoolbar();
        if (this.isAnimated()) {
            this.startAnimationThreads(this.toolItem);
        }
    }

    public static void openEditor() {
        ShowMyAptanaAction.switchPerspective();
        IPreferenceStore prefs = IntroPlugin.getDefault().getPreferenceStore();
        String editorId = prefs.getString("com.aptana.ide.intro.INTRO_EDITOR_ID");
        IEditorPart editorPart = CoreUIUtils.openEditor((String)editorId, (boolean)true);
        if (editorPart == null) {
            editorId = prefs.getDefaultString("com.aptana.ide.intro.INTRO_EDITOR_ID");
            prefs.setValue("com.aptana.ide.intro.INTRO_EDITOR_ID", editorId);
            CoreUIUtils.openEditor((String)editorId, (boolean)true);
        }
    }

    private void buildMenu(Menu menu) {
        ActionUtils.buildMenu(menu, this.window);
    }

    private static void switchPerspective() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (PerspectiveManager.shouldSwitchPerspective((IWorkbenchWindow)window, (String)"com.aptana.ide.js.ui.WebPerspective")) {
            PerspectiveManager.switchToPerspective((IWorkbenchWindow)window, (String)"com.aptana.ide.js.ui.WebPerspective");
        }
    }

    private void setDefaultImage(String filepath) {
        if (filepath == null || filepath.length() == 0) {
            return;
        }
        this.loader = new ImageLoader();
        try {
            this.imageData = this.loader.load(filepath);
            if (this.imageData.length > 0) {
                this.image = new Image[1];
                this.image[0] = new Image((Device)Display.getCurrent(), this.imageData[0]);
                this.toolItem.setImage(this.image[0]);
                this.updateCoolbar();
            }
        }
        catch (Exception e) {
            IdeLog.logImportant((Plugin)IntroPlugin.getDefault(), (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void loadImage() {
        this.loader = new ImageLoader();
        boolean loaded = false;
        InputStream stream = this.getRemoteImageStream();
        if (stream != null) {
            try {
                this.imageData = this.loader.load(stream);
                loaded = true;
                this.cacheImage();
            }
            catch (SWTException sWTException) {}
        }
        if (!loaded) {
            this.imageData = this.loader.load(this.getLocalImageStream());
        }
        int numFramesOfAnimation = this.imageData.length;
        this.image = new Image[numFramesOfAnimation];
        int fullWidth = this.loader.logicalScreenWidth;
        int fullHeight = this.loader.logicalScreenHeight;
        Display display = Display.getCurrent();
        int i = 0;
        while (i < numFramesOfAnimation) {
            if (i == 0) {
                this.image[i] = new Image((Device)display, this.imageData[i]);
                fullWidth = this.imageData[i].width;
                fullHeight = this.imageData[i].height;
            } else {
                this.image[i] = new Image((Device)display, fullWidth, fullHeight);
                GC gc = new GC((Drawable)this.image[i]);
                gc.fillRectangle(0, 0, fullWidth, fullHeight);
                switch (this.imageData[i].disposalMethod) {
                    case 2: {
                        gc.fillRectangle(this.imageData[i].x, this.imageData[i].y, this.imageData[i].width, this.imageData[i].height);
                        break;
                    }
                    default: {
                        gc.drawImage(this.image[i - 1], 0, 0, fullWidth, fullHeight, 0, 0, fullWidth, fullHeight);
                    }
                }
                Image newFrame = new Image((Device)display, this.imageData[i]);
                gc.drawImage(newFrame, 0, 0, this.imageData[i].width, this.imageData[i].height, this.imageData[i].x, this.imageData[i].y, this.imageData[i].width, this.imageData[i].height);
                newFrame.dispose();
                gc.dispose();
            }
            ++i;
        }
    }

    private void startAnimationThreads(final ToolItem item) {
        this.animationRunning = true;
        this.animateThread = new Thread("Intro icon animation"){
            private int imageDataIndex;
            {
                super($anonymous0);
                this.imageDataIndex = 0;
            }

            public void run() {
                Display display = Display.getDefault();
                try {
                    int repeatCount = ((ShowMyAptanaAction)ShowMyAptanaAction.this).loader.repeatCount;
                    while (ShowMyAptanaAction.this.animationRunning && (((ShowMyAptanaAction)ShowMyAptanaAction.this).loader.repeatCount == 0 || repeatCount > 0)) {
                        this.imageDataIndex = (this.imageDataIndex + 1) % ShowMyAptanaAction.this.imageData.length;
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                public void run() {
                                    if (!item.isDisposed()) {
                                        item.setImage(ShowMyAptanaAction.this.image[imageDataIndex]);
                                    }
                                }
                            });
                        }
                        try {
                            int ms = ((ShowMyAptanaAction)ShowMyAptanaAction.this).imageData[this.imageDataIndex].delayTime * 10;
                            if (ms < 20) {
                                ms += 30;
                            }
                            if (ms < 30) {
                                ms += 10;
                            }
                            Thread.sleep(ms);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (this.imageDataIndex != ShowMyAptanaAction.this.imageData.length - 1) continue;
                        --repeatCount;
                    }
                }
                catch (SWTException e) {
                    IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        this.animateThread.setDaemon(true);
        this.animateThread.start();
    }

    private boolean isAnimated() {
        return this.imageData.length > 1;
    }

    private boolean isRemoteImageUpdated() {
        HttpURLConnection httpURLConnection = null;
        try {
            URL location = new URL(ShowMyAptanaAction.getRemoteImageLocation());
            URLConnection urlConnection = location.openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)urlConnection;
                httpURLConnection.setConnectTimeout(1000);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.addRequestProperty("Cache-Control", "no-cache");
                httpURLConnection.setRequestMethod("HEAD");
                if (httpURLConnection.getResponseCode() == 200) {
                    long lastLastModified;
                    boolean updated = true;
                    IPreferenceStore pref = IntroPlugin.getDefault().getPreferenceStore();
                    long lastModified = httpURLConnection.getLastModified();
                    if (lastModified != 0L && (lastLastModified = pref.getLong(location.toString())) >= lastModified) {
                        updated = false;
                    }
                    pref.setValue(location.toString(), lastModified);
                    boolean bl = updated;
                    return bl;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return false;
    }

    private InputStream getLocalImageStream() {
        File file = this.getLocalImageFile();
        if (file.exists()) {
            try {
                return file.toURI().toURL().openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        return this.getClass().getResourceAsStream(LOCAL_IMAGE_LOCATION);
    }

    private InputStream getRemoteImageStream() {
        String remoteLocation = ShowMyAptanaAction.getRemoteImageLocation();
        try {
            URL url = new URL(remoteLocation);
            if (OnlineDetectionService.isAvailable((URL)url)) {
                return url.openStream();
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private File getLocalImageFile() {
        IPath directory = IntroPlugin.getDefault().getStateLocation();
        String remotePath = ShowMyAptanaAction.getRemoteImageLocation();
        String ext = ShowMyAptanaAction.getExtension(remotePath);
        return directory.append(CACHED_IMAGE + ext).toFile();
    }

    private void cacheImage() {
        String filepath = this.getLocalImageFile().getAbsolutePath();
        this.loader.save(filepath, ShowMyAptanaAction.getImageFormat(ShowMyAptanaAction.getExtension(filepath)));
    }

    private boolean haventCheckedInADay() {
        return this.lastChecked == 0L || this.lastChecked < System.currentTimeMillis() - 86400000L;
    }

    private void updateCoolbar() {
        ((WorkbenchWindow)this.window).getCoolBarManager().update(true);
    }

    private static String getRemoteImageLocation() {
        return IntroPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.intro.INTRO_TOOLBAR_IMAGE_LOCATION");
    }

    private static String getExtension(String filepath) {
        int index = filepath.lastIndexOf(".");
        return index < 0 ? "" : filepath.substring(index);
    }

    private static int getImageFormat(String extension) {
        if (extension.equals(".png")) {
            return 5;
        }
        if (extension.equals(".gif")) {
            return 2;
        }
        if (extension.equals(".bmp")) {
            return 0;
        }
        if (extension.equals(".jpg")) {
            return 4;
        }
        return 3;
    }
}

