/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.ClientUtils;
import com.aptana.ide.intro.actions.Messages;
import com.aptana.ide.server.jetty.comet.CometClient;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewWizardAction;
import org.eclipse.ui.internal.wizards.NewWizardRegistry;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewFileWizardClient
extends CometClient {
    public static final String NEW_FILE = "/portal/files/new";
    private static final String PROJECT = "project";
    private static final String SYSTEM = "system";

    protected Object getResponse(String toChannel, Object request) {
        if (NEW_FILE.equals(toChannel) && request instanceof String) {
            final String type = (String)request;
            UIJob job = new UIJob(Messages.NewFileWizardClient_Job_NewFilesDialog){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        if (type.equals(NewFileWizardClient.PROJECT)) {
                            IWizardDescriptor descriptor = NewWizardRegistry.getInstance().findWizard("org.eclipse.ui.wizards.new.file");
                            if (descriptor != null) {
                                IWorkbenchWizard wizard = descriptor.createWizard();
                                wizard.init(IntroPlugin.getDefault().getWorkbench(), ClientUtils.getNavigatorSelection());
                                if (wizard instanceof IWizard) {
                                    WizardDialog dialog = new WizardDialog(CoreUIUtils.getActiveShell(), (IWizard)wizard);
                                    dialog.create();
                                    if (wizard.getPageCount() > 0) {
                                        dialog.open();
                                    }
                                }
                            }
                        } else if (type.equals(NewFileWizardClient.SYSTEM)) {
                            NewWizardAction action = new NewWizardAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                            action.setCategoryId("com.aptana.ide.core.ui");
                            action.run();
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)Messages.NewFileWizardClient_Job_ErrorLaunchWizard, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{NEW_FILE};
    }

    protected String getID(String msgId) {
        return NEW_FILE;
    }
}

