/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.ui.views.problems;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileServiceChangeListener;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.IFileErrorListener;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;

public class ProblemsPage
extends Page
implements IFileErrorListener,
IFileServiceChangeListener {
    private Composite displayArea;
    private TableViewer viewer;
    private Label statusText;
    private static String[] COLUMN_NAMES = new String[]{"", "Description", "Resource", "In Folder", "Location"};
    private static int[] COLUMN_WIDTHS = new int[]{20, 200, 300, 75, 60};
    private IFileError[] errors = null;
    private IFileService service;
    private IUnifiedEditor editor;

    public IFileService getFileService() {
        return this.service;
    }

    public ProblemsPage(IUnifiedEditor editor) {
        this.editor = editor;
        this.service = this.editor.getFileContext();
        this.editor.addFileServiceChangeListener((IFileServiceChangeListener)this);
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.aptana.ide.editors.ProblemsView");
        this.displayArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        this.displayArea.setLayout((Layout)layout);
        this.statusText = new Label(this.displayArea, 0);
        this.statusText.setText("0 errors");
        this.statusText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.viewer = new TableViewer(this.displayArea, 66306);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            TableColumn tc1 = new TableColumn(this.viewer.getTable(), 16384);
            tc1.setText(COLUMN_NAMES[i]);
            tc1.setWidth(COLUMN_WIDTHS[i]);
            ++i;
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ProblemsPage.this.viewerSelectionChanged(selection);
            }
        });
        PreferenceUtils.persist((IPreferenceStore)UnifiedEditorsPlugin.getDefault().getPreferenceStore(), (Table)this.viewer.getTable(), (String)ProblemsPage.class.getName());
        PreferenceUtils.registerBackgroundColorPreference((Control)this.viewer.getControl(), (String)"com.aptana.ide.core.ui.background.color.validationView");
        PreferenceUtils.registerForegroundColorPreference((Control)this.viewer.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.validationView");
        this.service.addErrorListener((IFileErrorListener)this);
        this.onErrorsChanged(this.service.getFileErrors());
    }

    protected void viewerSelectionChanged(IStructuredSelection selection) {
        ViewContentItem item;
        IEditorPart ed = null;
        try {
            ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (Exception exception) {
            return;
        }
        if (ed instanceof IUnifiedEditor && (item = (ViewContentItem)selection.getFirstElement()) != null) {
            ((IUnifiedEditor)ed).selectAndReveal(item.offset, item.len);
        }
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removeFileServiceChangeListener((IFileServiceChangeListener)this);
        }
        if (this.service != null) {
            this.service.removeErrorListener((IFileErrorListener)this);
        }
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void onErrorsChanged(final IFileError[] errors) {
        this.errors = errors;
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                if (ProblemsPage.this.viewer != null && ProblemsPage.this.viewer.getContentProvider() != null) {
                    try {
                        if (ProblemsPage.this.viewer.getInput() == null) {
                            ProblemsPage.this.viewer.setInput((Object)ProblemsPage.this.getSite());
                        } else {
                            ProblemsPage.this.viewer.refresh();
                        }
                        int errorCount = 0;
                        int warningCount = 0;
                        if (ProblemsPage.this.errors != null) {
                            int i = 0;
                            while (i < errors.length) {
                                if (errors[i].getSeverity() == 2) {
                                    ++errorCount;
                                } else if (errors[i].getSeverity() == 1) {
                                    ++warningCount;
                                }
                                ++i;
                            }
                        }
                        String errorString = String.valueOf(errorCount) + " error";
                        errorString = String.valueOf(errorString) + (errorCount > 1 ? "s" : "");
                        String warningString = String.valueOf(warningCount) + " warning";
                        warningString = String.valueOf(warningString) + (warningCount > 1 ? "s" : "");
                        if (errorCount > 0 && warningCount > 0) {
                            ProblemsPage.this.statusText.setText(String.valueOf(errorString) + ", " + warningString);
                        } else if (errorCount > 0) {
                            ProblemsPage.this.statusText.setText(errorString);
                        } else if (warningCount > 0) {
                            ProblemsPage.this.statusText.setText(warningString);
                        } else {
                            ProblemsPage.this.statusText.setText("0 problems");
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Error", (Throwable)e);
                    }
                }
            }
        });
    }

    public Control getControl() {
        return this.displayArea;
    }

    public void fileServiceChanged(IFileService newService) {
        if (this.service != null) {
            this.service.removeErrorListener((IFileErrorListener)this);
        }
        this.service = newService;
        if (this.service != null) {
            this.service.addErrorListener((IFileErrorListener)this);
            this.onErrorsChanged(this.service.getFileErrors());
        } else {
            this.onErrorsChanged(null);
        }
    }

    class NameSorter
    extends ViewerSorter {
        public int category(Object element) {
            ViewContentItem item = (ViewContentItem)element;
            return item.icon == 2 ? 0 : 1;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            ViewContentItem item1 = (ViewContentItem)e1;
            ViewContentItem item2 = (ViewContentItem)e2;
            return item1.loc - item2.loc;
        }
    }

    class ViewContentItem {
        public int icon;
        public String desc;
        public String res;
        public String folder;
        public int loc;
        public int offset;
        public int len;

        public ViewContentItem(int ic, String n, String i, String s, int l, int o, int le) {
            this.icon = ic;
            this.desc = n;
            this.res = i;
            this.folder = s;
            this.loc = l;
            this.offset = o;
            this.len = le;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (ProblemsPage.this.errors == null) {
                return new Object[0];
            }
            ArrayList<ViewContentItem> list = new ArrayList<ViewContentItem>();
            int i = 0;
            while (i < ProblemsPage.this.errors.length) {
                IFileError e = ProblemsPage.this.errors[i];
                list.add(new ViewContentItem(e.getSeverity(), e.getMessage(), e.getFileName(), e.getFolderPath(), e.getLineNumber(), e.getOffset(), e.getLength()));
                ++i;
            }
            return list.toArray(new Object[0]);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 0: {
                    return "";
                }
                case 1: {
                    return ((ViewContentItem)obj).desc;
                }
                case 2: {
                    return ((ViewContentItem)obj).res;
                }
                case 3: {
                    return ((ViewContentItem)obj).folder;
                }
                case 4: {
                    return "line " + ((ViewContentItem)obj).loc;
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                case 0: {
                    return this.getImage(obj);
                }
            }
            return null;
        }

        public Image getImage(Object obj) {
            int i = ((ViewContentItem)obj).icon;
            if (i == 2) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            if (i == 1) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            return null;
        }
    }
}

