/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.portal.ui;

import com.aptana.ide.core.db.EventLogger;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.browser.BaseBrowserAdapter;
import com.aptana.ide.core.ui.browser.BrowserRegistry;
import com.aptana.ide.core.ui.browser.IBrowser;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.portal.PortalPlugin;
import com.aptana.ide.server.portal.server.MyAptanaServer;
import com.aptana.ide.server.portal.ui.Messages;
import com.aptana.ide.server.portal.ui.MyAptanaEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class MyAptanaEditor
extends EditorPart {
    public static final String ID = "com.aptana.ide.server.portal.ui.MyAptanaEditor";
    public static final IEditorInput INPUT = new MyAptanaEditorInput();
    private static boolean open;
    private Composite displayArea;
    private IBrowser browser;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (MyAptanaEditor.ID.equals(part.getSite().getId())) {
                this.log("ma.closed");
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (MyAptanaEditor.ID.equals(part.getSite().getId())) {
                this.log("ma.opened");
            }
        }

        private void log(String eventType) {
            EventLogger.getInstance().logEvent(eventType);
        }
    };

    public static boolean isOpen() {
        return open;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        super.dispose();
        open = false;
        try {
            if (this.browser != null) {
                this.browser.dispose();
                this.browser = null;
            }
        }
        catch (Exception exception) {}
        Job job = new Job("Restart the server for My Studio"){

            protected IStatus run(IProgressMonitor monitor) {
                MyAptanaServer.getServer().restart();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(40);
        job.schedule();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        site.getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        open = true;
        if (input != INPUT) {
            input = INPUT;
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(Messages.MyAptanaEditor_Title);
        this.setTitleToolTip(Messages.MyAptanaEditor_TitleTooltip);
        this.setTitleImage(PortalPlugin.getImage("icons/startpage.png"));
        PortalPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.server.portal.MY_APTANA_PREVIOUSLY_OPENED", false);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout();
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        if (JettyPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.server.jetty.preferences.USE_FIREFOX") && CoreUIUtils.onWindows) {
            this.browser = BrowserRegistry.getRegistry().getBrowser("com.aptana.ide.xul.firefox");
        }
        if (this.browser == null) {
            this.browser = new BaseBrowserAdapter();
        }
        this.browser.createControl(this.displayArea);
        this.browser.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.updateContent();
    }

    public void setFocus() {
        this.displayArea.setFocus();
    }

    private void updateContent() {
        final String url = MyAptanaServer.getServer().getStartURL().toExternalForm();
        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (MyAptanaEditor.this.browser != null && !MyAptanaEditor.this.browser.getControl().isDisposed()) {
                    MyAptanaEditor.this.browser.setURL(url);
                }
            }
        });
    }
}

