/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.ftp.dialogs;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.ui.PixelConverter;
import com.aptana.ide.filesystem.ftp.Policy;
import com.aptana.ide.ui.IPropertyDialog;
import com.aptana.ide.ui.ftp.Activator;
import com.aptana.ide.ui.ftp.dialogs.Messages;
import com.aptana.ide.ui.ftp.internal.FTPAdvancedOptionsComposite;
import com.aptana.ide.ui.ftp.internal.IConnectionDialog;
import com.aptana.ide.ui.ftp.internal.IConnectionRunnable;
import com.aptana.ide.ui.ftp.internal.IOptionsComposite;
import com.aptana.ide.ui.io.FileSystemUtils;
import com.aptana.ide.ui.io.dialogs.FileTreeSelectionDialog;
import com.aptana.ide.ui.io.dialogs.IDialogConstants;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class FTPConnectionPointPropertyDialog
extends TitleAreaDialog
implements IPropertyDialog,
IConnectionDialog {
    private static final String DEFAULT_NAME = Messages.FTPConnectionPointPropertyDialog_Title;
    private static final Pattern HOST_PATTERN = Pattern.compile("^(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|([-\\w]+(\\.[-\\w]+)*)$");
    protected IBaseRemoteConnectionPoint ftpConnectionPoint;
    protected IBaseRemoteConnectionPoint originalFtpConnectionPoint;
    private boolean isNew = false;
    private Text nameText;
    private Text hostText;
    private Text remotePathText;
    private Combo loginCombo;
    protected Label passwordLabel;
    protected Text passwordText;
    protected Button savePasswordButton;
    private Button testButton;
    private Button browseButton;
    protected ExpandableComposite optionsExpandable;
    protected IOptionsComposite advancedOptions;
    private ProgressMonitorPart progressMonitorPart;
    private boolean lockedUI;
    private boolean connectionTested;
    private ModifyListener modifyListener;
    private SelectionListener selectionListener;
    private Image titleImage;
    protected Font smallFont;

    public FTPConnectionPointPropertyDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setPropertySource(Object element) {
        this.ftpConnectionPoint = null;
        if (element instanceof IBaseRemoteConnectionPoint) {
            this.ftpConnectionPoint = (IBaseRemoteConnectionPoint)element;
        }
    }

    public Object getPropertySource() {
        return this.ftpConnectionPoint;
    }

    protected ConnectionPointType getConnectionPointType() {
        if (this.ftpConnectionPoint != null) {
            return CoreIOPlugin.getConnectionPointManager().getType((IConnectionPoint)this.ftpConnectionPoint);
        }
        return CoreIOPlugin.getConnectionPointManager().getType("ftp");
    }

    protected void createSiteSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)Messages.FTPConnectionPointPropertyDialog_LBL_SiteName));
        this.nameText = new Text(parent, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
    }

    protected void createPasswordSection(Composite parent) {
        this.passwordLabel = new Label(parent, 0);
        this.passwordLabel.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this.passwordLabel).convertHorizontalDLUsToPixels(55), -1).create());
        this.passwordLabel.setText(StringUtils.makeFormLabel((String)Messages.FTPConnectionPointPropertyDialog_LBL_Password));
        this.passwordText = new Text(parent, 0x400804);
        this.passwordText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
        this.savePasswordButton = new Button(parent, 32);
        this.savePasswordButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.savePasswordButton.setText(Messages.FTPConnectionPointPropertyDialog_LBL_Save);
    }

    protected void createAdvancedOptions(Composite parent) {
        this.advancedOptions = new FTPAdvancedOptionsComposite(parent, 0, this);
        ((Composite)this.advancedOptions).setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.titleImage = Activator.getImageDescriptor("/icons/full/wizban/ftp.png").createImage();
        this.smallFont = JFaceResources.getTextFontDescriptor().increaseHeight(-2).createFont((Device)dialogArea.getDisplay());
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FTPConnectionPointPropertyDialog.this.dispose();
            }
        });
        this.setTitleImage(this.titleImage);
        if (this.ftpConnectionPoint != null) {
            this.setTitle(StringUtils.format((String)Messages.FTPConnectionPointPropertyDialog_MessageTitle_Edit, (String)this.getConnectionPointType().getName()));
            this.getShell().setText(Messages.FTPConnectionPointPropertyDialog_Title_Edit);
        } else {
            this.setTitle(StringUtils.format((String)Messages.FTPConnectionPointPropertyDialog_MessageTitle_New, (String)this.getConnectionPointType().getName()));
            this.getShell().setText(Messages.FTPConnectionPointPropertyDialog_Title_New);
        }
        Composite container = new Composite(dialogArea, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).spacing(this.convertHorizontalDLUsToPixels(4), this.convertVerticalDLUsToPixels(4)).numColumns(2).create());
        this.createSiteSection(container);
        Group group = new Group(container, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        group.setText(Messages.FTPConnectionPointPropertyDialog_LBL_GroupInfo);
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)Messages.FTPConnectionPointPropertyDialog_LBL_Server));
        this.hostText = new Text((Composite)group, 2052);
        this.hostText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).create());
        new Label((Composite)group, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        label.setFont(this.smallFont);
        label.setText(Messages.FTPConnectionPointPropertyDialog_LBL_Example);
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)Messages.FTPConnectionPointPropertyDialog_LBL_Username));
        this.loginCombo = new Combo((Composite)group, 2052);
        this.loginCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
        this.loginCombo.add("anonymous");
        this.testButton = new Button((Composite)group, 8);
        this.testButton.setText(Messages.FTPConnectionPointPropertyDialog_LBL_Test);
        this.testButton.setLayoutData((Object)GridDataFactory.fillDefaults().hint(Math.max(new PixelConverter((Control)this.testButton).convertHorizontalDLUsToPixels(61), this.testButton.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        this.createPasswordSection((Composite)group);
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)Messages.FTPConnectionPointPropertyDialog_LBL_RemotePath));
        this.remotePathText = new Text((Composite)group, 2052);
        this.remotePathText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).create());
        this.browseButton = new Button((Composite)group, 8);
        this.browseButton.setText(String.valueOf('&') + StringUtils.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.setLayoutData((Object)GridDataFactory.fillDefaults().hint(Math.max(new PixelConverter((Control)this.browseButton).convertHorizontalDLUsToPixels(61), this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        this.optionsExpandable = new ExpandableComposite(container, 0, 10);
        this.optionsExpandable.setText(Messages.FTPConnectionPointPropertyDialog_LBL_Options);
        this.optionsExpandable.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        Group optionsGroup = new Group((Composite)this.optionsExpandable, 0);
        optionsGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.createAdvancedOptions((Composite)optionsGroup);
        this.optionsExpandable.setClient((Control)optionsGroup);
        this.optionsExpandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                FTPConnectionPointPropertyDialog.this.layoutShell();
            }
        });
        this.progressMonitorPart = new ProgressMonitorPart(container, (Layout)GridLayoutFactory.fillDefaults().create());
        this.progressMonitorPart.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).exclude(true).span(2, 1).create());
        this.addListeners();
        this.passwordText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                e.doit = false;
                FTPConnectionPointPropertyDialog.this.testConnection();
            }
        });
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FTPConnectionPointPropertyDialog.this.testConnection()) {
                    MessageDialog.openInformation((Shell)FTPConnectionPointPropertyDialog.this.getShell(), (String)Messages.FTPConnectionPointPropertyDialog_Succeed_Title, (String)StringUtils.format((String)Messages.FTPConnectionPointPropertyDialog_Succeed_Message, (String)FTPConnectionPointPropertyDialog.this.hostText.getText()));
                }
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FTPConnectionPointPropertyDialog.this.browseConnection();
            }
        });
        if (this.ftpConnectionPoint == null) {
            this.isNew = true;
            this.ftpConnectionPoint = this.getOrCreateConnectionPoint(this.getConnectionPointType());
            this.ftpConnectionPoint.setName(DEFAULT_NAME);
        } else {
            this.originalFtpConnectionPoint = this.ftpConnectionPoint;
        }
        this.loadPropertiesFrom(this.ftpConnectionPoint);
        this.connectionTested = !this.isNew;
        return dialogArea;
    }

    protected IBaseRemoteConnectionPoint getOrCreateConnectionPoint(ConnectionPointType connectionPointType) {
        if (!this.isNew && CoreIOPlugin.getConnectionPointManager().getType((IConnectionPoint)this.originalFtpConnectionPoint).equals(connectionPointType)) {
            return this.originalFtpConnectionPoint;
        }
        try {
            return (IBaseRemoteConnectionPoint)CoreIOPlugin.getConnectionPointManager().createConnectionPoint(connectionPointType);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)Messages.FTPConnectionPointPropertyDialog_ERR_FailedCreate, (Throwable)e);
            this.close();
            throw new SWTException();
        }
    }

    protected void dispose() {
        if (this.titleImage != null) {
            this.setTitleImage(null);
            this.titleImage.dispose();
            this.titleImage = null;
        }
        if (this.smallFont != null) {
            this.smallFont.dispose();
            this.smallFont = null;
        }
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FTPConnectionPointPropertyDialog.this.validate();
                    if (e.widget != FTPConnectionPointPropertyDialog.this.nameText) {
                        FTPConnectionPointPropertyDialog.this.connectionTested = false;
                    }
                }
            };
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.hostText.addModifyListener(this.modifyListener);
        this.loginCombo.addModifyListener(this.modifyListener);
        this.passwordText.addModifyListener(this.modifyListener);
        this.remotePathText.addModifyListener(this.modifyListener);
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FTPConnectionPointPropertyDialog.this.validate();
                }
            };
        }
        this.loginCombo.addSelectionListener(this.selectionListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.nameText.removeModifyListener(this.modifyListener);
            this.hostText.removeModifyListener(this.modifyListener);
            this.loginCombo.removeModifyListener(this.modifyListener);
            this.passwordText.removeModifyListener(this.modifyListener);
            this.remotePathText.removeModifyListener(this.modifyListener);
        }
        if (this.selectionListener != null) {
            this.loginCombo.removeSelectionListener(this.selectionListener);
        }
    }

    protected void layoutShell() {
        Point size = this.getInitialSize();
        Rectangle bounds = this.getConstrainedShellBounds(new Rectangle(0, 0, size.x, size.y));
        this.getShell().setSize(bounds.width, bounds.height);
    }

    protected boolean canHandleShellCloseEvent() {
        return !this.lockedUI && super.canHandleShellCloseEvent();
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        if (DEFAULT_NAME.equals(this.nameText.getText())) {
            this.nameText.setText(this.hostText.getText());
        }
        if (!this.connectionTested && !this.testConnection()) {
            MessageDialog dlg = new MessageDialog(this.getShell(), Messages.FTPConnectionPointPropertyDialog_ConfirmTitle, null, Messages.FTPConnectionPointPropertyDialog_ConfirmMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, Messages.FTPConnectionPointPropertyDialog_LBL_Edit}, 2);
            int code = dlg.open();
            switch (code) {
                case 1: {
                    super.okPressed();
                }
                case 2: {
                    return;
                }
            }
        }
        CoreIOPlugin.getAuthenticationManager().setPassword(this.getAuthId(this.ftpConnectionPoint), this.passwordText.getText().toCharArray(), this.savePasswordButton.getSelection());
        boolean changed = this.savePropertiesTo(this.ftpConnectionPoint);
        if (this.isNew) {
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint((IConnectionPoint)this.ftpConnectionPoint);
        } else if (this.ftpConnectionPoint != this.originalFtpConnectionPoint) {
            CoreIOPlugin.getConnectionPointManager().removeConnectionPoint((IConnectionPoint)this.originalFtpConnectionPoint);
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint((IConnectionPoint)this.ftpConnectionPoint);
        } else if (changed) {
            CoreIOPlugin.getConnectionPointManager().connectionPointChanged((IConnectionPoint)this.ftpConnectionPoint);
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.progressMonitorPart.setCanceled(true);
        if (!this.lockedUI) {
            super.cancelPressed();
        }
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.validate();
        }
    }

    protected String getAuthId(IBaseRemoteConnectionPoint connectionPoint) {
        return Policy.generateAuthId((String)this.getConnectionPointType().getType().toUpperCase(), (IBaseRemoteConnectionPoint)connectionPoint);
    }

    protected void loadPropertiesFrom(IBaseRemoteConnectionPoint connectionPoint) {
        this.removeListeners();
        try {
            this.nameText.setText(FTPConnectionPointPropertyDialog.valueOrEmpty(connectionPoint.getName()));
            this.hostText.setText(FTPConnectionPointPropertyDialog.valueOrEmpty(connectionPoint.getHost()));
            this.remotePathText.setText(connectionPoint.getPath().toPortableString());
            String login = connectionPoint.getLogin();
            int index = this.loginCombo.indexOf(login);
            if (index >= 0) {
                this.loginCombo.select(index);
            } else {
                this.loginCombo.setText(login);
            }
            String authId = this.getAuthId(connectionPoint);
            boolean persistent = CoreIOPlugin.getAuthenticationManager().hasPersistent(authId);
            this.savePasswordButton.setSelection(persistent);
            char[] password = connectionPoint.getPassword();
            if (persistent && password == null) {
                password = CoreIOPlugin.getAuthenticationManager().getPassword(authId);
            }
            if (password != null) {
                this.passwordText.setText(String.copyValueOf(password));
            }
            this.advancedOptions.loadPropertiesFrom(connectionPoint);
        }
        finally {
            this.addListeners();
        }
    }

    protected boolean savePropertiesTo(IBaseRemoteConnectionPoint connectionPoint) {
        char[] password;
        String login;
        String host;
        boolean updated = false;
        String name = this.nameText.getText();
        if (!name.equals(connectionPoint.getName())) {
            connectionPoint.setName(name);
            updated = true;
        }
        if (!(host = this.hostText.getText()).equals(connectionPoint.getHost())) {
            connectionPoint.setHost(host);
            updated = true;
        }
        IPath path = Path.fromPortableString((String)this.remotePathText.getText());
        if (!connectionPoint.getPath().equals((Object)path)) {
            connectionPoint.setPath(path);
            updated = true;
        }
        if (!(login = this.loginCombo.getText()).equals(connectionPoint.getLogin())) {
            connectionPoint.setLogin(login);
            updated = true;
        }
        if (!Arrays.equals(password = this.passwordText.getText().toCharArray(), connectionPoint.getPassword())) {
            connectionPoint.setPassword(password);
            updated = true;
        }
        if (this.advancedOptions.savePropertiesTo(connectionPoint)) {
            updated = true;
        }
        return updated;
    }

    public void validate() {
        Button button = this.getButton(0);
        if (button == null) {
            return;
        }
        boolean valid = this.isValid();
        button.setEnabled(valid);
        this.testButton.setEnabled(valid);
        this.browseButton.setEnabled(valid);
        this.advancedOptions.setValid(valid);
    }

    public boolean isValid() {
        String message = null;
        message = this.nameText.getText().length() == 0 ? Messages.FTPConnectionPointPropertyDialog_ERR_NameEmpty : (!HOST_PATTERN.matcher(this.hostText.getText()).matches() ? Messages.FTPConnectionPointPropertyDialog_ERR_InvalidHost : (this.loginCombo.getText().length() == 0 ? Messages.FTPConnectionPointPropertyDialog_ERR_NoUsername : this.advancedOptions.isValid()));
        this.setErrorMessage(message);
        return message == null;
    }

    private boolean testConnection() {
        return this.testConnection(null, null);
    }

    public boolean testConnection(ConnectionContext context, final IConnectionRunnable connectRunnable) {
        this.hostText.getText();
        this.loginCombo.getText();
        this.passwordText.getText();
        this.remotePathText.getText();
        this.lockUI(true);
        ((GridData)this.progressMonitorPart.getLayoutData()).exclude = false;
        this.layoutShell();
        try {
            final IBaseRemoteConnectionPoint connectionPoint = this.isNew ? this.ftpConnectionPoint : (IBaseRemoteConnectionPoint)CoreIOPlugin.getConnectionPointManager().cloneConnectionPoint((IConnectionPoint)this.ftpConnectionPoint);
            this.savePropertiesTo(connectionPoint);
            if (context == null) {
                context = new ConnectionContext();
                context.setBoolean("quick_connect", true);
            }
            context.setBoolean("no_password_prompt", true);
            CoreIOPlugin.setConnectionContext((Object)connectionPoint, (ConnectionContext)context);
            ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            try {
                                if (connectRunnable != null) {
                                    connectRunnable.beforeConnect((IConnectionPoint)connectionPoint);
                                }
                                connectionPoint.connect(monitor);
                                if (connectRunnable != null) {
                                    connectRunnable.afterConnect((IConnectionPoint)connectionPoint, monitor);
                                }
                            }
                            finally {
                                try {
                                    connectionPoint.disconnect(monitor);
                                }
                                catch (CoreException e) {
                                    IdeLog.logImportant((Plugin)Activator.getDefault(), (String)"", (Throwable)e);
                                }
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }, (boolean)true, (IProgressMonitor)this.progressMonitorPart, (Display)this.getShell().getDisplay());
            this.connectionTested = true;
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            this.showErrorDialog(e.getTargetException());
        }
        catch (CoreException e) {
            this.showErrorDialog(e);
        }
        finally {
            if (!this.progressMonitorPart.isDisposed()) {
                ((GridData)this.progressMonitorPart.getLayoutData()).exclude = true;
                this.layoutShell();
                this.lockUI(false);
            }
        }
        return false;
    }

    private void browseConnection() {
        this.testConnection(null, new IConnectionRunnable(){

            public void afterConnect(final IConnectionPoint connectionPoint, IProgressMonitor monitor) throws CoreException, InterruptedException {
                monitor.beginTask(Messages.FTPConnectionPointPropertyDialog_Task_Browse, -1);
                monitor.subTask("");
                FTPConnectionPointPropertyDialog.this.getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        FTPConnectionPointPropertyDialog.this.showBrowseDialog(connectionPoint);
                    }
                });
                monitor.done();
            }

            public void beforeConnect(IConnectionPoint connectionPoint) throws CoreException, InterruptedException {
                ((IBaseRemoteConnectionPoint)connectionPoint).setPath((IPath)Path.ROOT);
            }
        });
    }

    private void showBrowseDialog(IConnectionPoint connectionPoint) {
        URI uri;
        FileTreeSelectionDialog dlg = new FileTreeSelectionDialog(this.getShell(), false);
        dlg.setTitle(StringUtils.format((String)Messages.FTPConnectionPointPropertyDialog_Title_Browse, (String)((IBaseRemoteConnectionPoint)connectionPoint).getHost()));
        dlg.setMessage(StringUtils.makeFormLabel((String)Messages.FTPConnectionPointPropertyDialog_Message_Browse));
        dlg.setInput((Object)connectionPoint);
        String pathString = this.remotePathText.getText();
        try {
            IFileStore selection = connectionPoint.getRoot();
            if (pathString.length() > 0) {
                selection = selection.getFileStore(Path.fromPortableString((String)pathString));
            }
            dlg.setInitialSelection((Object)selection);
        }
        catch (CoreException e) {
            IdeLog.logImportant((Plugin)Activator.getDefault(), (String)"", (Throwable)e);
        }
        if (dlg.open() == 0 && (uri = FileSystemUtils.getURI((Object)dlg.getFirstResult())) != null) {
            String path = Path.fromPortableString((String)connectionPoint.getRootURI().relativize(uri).toString()).makeAbsolute().toPortableString();
            this.remotePathText.setText(path);
        }
    }

    private void showErrorDialog(Throwable e) {
        String message = Messages.FTPConnectionPointPropertyDialog_DefaultErrorMsg;
        if (e instanceof CoreException) {
            message = ((CoreException)e).getStatus().getMessage();
        }
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.FTPConnectionPointPropertyDialog_ErrorTitle, (String)message);
    }

    protected void lockUI(boolean lock) {
        this.lockedUI = lock;
        this.getButton(0).setEnabled(!lock);
        this.nameText.setEnabled(!lock);
        this.hostText.setEnabled(!lock);
        this.loginCombo.setEnabled(!lock);
        this.passwordText.setEnabled(!lock);
        this.savePasswordButton.setEnabled(!lock);
        this.remotePathText.setEnabled(!lock);
        this.remotePathText.setEnabled(!lock);
        this.testButton.setEnabled(!lock);
        this.browseButton.setEnabled(!lock);
        this.advancedOptions.lockUI(lock);
    }

    private static String valueOrEmpty(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }
}

