/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting.views;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.scripting.events.LocationChangedEvent;
import com.aptana.ide.scripting.events.LocationChangingEvent;
import com.aptana.ide.scripting.views.GenericScriptableView;
import com.aptana.ide.scripting.views.Messages;
import com.aptana.ide.scripting.views.View;
import com.aptana.ide.scripting.views.Views;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mozilla.javascript.Scriptable;

public class ScriptableView
extends View {
    private static final long serialVersionUID = -9171256728962509567L;
    private LocationListener _viewListener;
    private String _id;

    public IWorkbenchPart getView() {
        IWorkbenchPart result = super.getView();
        if (result == null) {
            result = Views.getViewInternal("com.aptana.ide.js.ui.views.GenericScriptableView", this._id);
            this.updateListeners(result, null);
        }
        return result;
    }

    public void setView(IWorkbenchPart view) {
        IWorkbenchPart currentView = this.getView();
        if (currentView != view) {
            this.updateListeners(view, currentView);
        }
    }

    protected void updateListeners(IWorkbenchPart view, IWorkbenchPart currentView) {
        GenericScriptableView pview;
        if (currentView != null && this._viewListener != null) {
            pview = (GenericScriptableView)currentView;
            pview.getBrowser().removeLocationListener(this._viewListener);
        }
        super.setView(view);
        if (view != null) {
            if (this._viewListener == null) {
                final ScriptableView self = this;
                this._viewListener = new LocationListener(){

                    public void changing(LocationEvent innerEvent) {
                        LocationChangingEvent event = new LocationChangingEvent(this, innerEvent);
                        self.fireEventListeners(event);
                        if (innerEvent.location.indexOf("aptana:") == 0) {
                            innerEvent.doit = false;
                        }
                    }

                    public void changed(LocationEvent innerEvent) {
                        LocationChangedEvent event = new LocationChangedEvent(this, innerEvent);
                        self.fireEventListeners(event);
                    }
                };
            }
            if (view instanceof GenericScriptableView) {
                pview = (GenericScriptableView)view;
                IWorkbench workbench = PlatformUI.getWorkbench();
                Display display = workbench.getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        pview.getBrowser().addLocationListener(ScriptableView.this._viewListener);
                    }
                });
            }
        }
    }

    public String getClassName() {
        return "ScriptableView";
    }

    public ScriptableView(Scriptable scope, IWorkbenchPart view, String id) {
        super(scope, view);
        this._id = id;
        String[] names = new String[]{"setHTML", "execute", "showView", "setTitle"};
        this.defineFunctionProperties(names, ScriptableView.class, 5);
        this.defineProperty("url", ScriptableView.class, 4);
    }

    public void showView(final boolean makeVisible) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.showView("com.aptana.ide.js.ui.views.GenericScriptableView", ScriptableView.this._id, makeVisible ? 2 : 3);
                }
                catch (PartInitException e) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptableView_Error, (Throwable)e);
                }
            }
        });
    }

    public void setTitle(final String title) {
        final IWorkbenchPart part = this.getView();
        if (part != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    GenericScriptableView view = (GenericScriptableView)part;
                    view.setViewTitle(title);
                }
            });
        }
    }

    public void setHTML(final String html) {
        final IWorkbenchPart part = this.getView();
        if (part != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    GenericScriptableView view = (GenericScriptableView)part;
                    view.setText(html);
                }
            });
        }
    }

    public void execute(final String script) {
        final IWorkbenchPart part = this.getView();
        if (part != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    GenericScriptableView view = (GenericScriptableView)part;
                    view.execute(script);
                }
            });
        }
    }

    public void setUrl(String url) {
        final IWorkbenchPart part = this.getView();
        if (part != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            final String finalUrl = url;
            display.asyncExec(new Runnable(){

                public void run() {
                    if (part instanceof GenericScriptableView) {
                        GenericScriptableView view = (GenericScriptableView)part;
                        view.setUrl(finalUrl);
                    }
                }
            });
        }
    }

    public String getUrl() {
        final IWorkbenchPart part = this.getView();
        String result = "";
        if (part != null) {
            class Url {
                public String value;

                Url() {
                }
            }
            final Url url = new Url();
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.syncExec(new Runnable(){
                {
                }

                public void run() {
                    String val;
                    GenericScriptableView view = (GenericScriptableView)part;
                    url.value = val = view.getUrl();
                }
            });
            result = url.value;
        }
        return result;
    }
}

