/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting.events;

import com.aptana.ide.scripting.ScriptingEngine;
import com.aptana.ide.scripting.events.Event;
import com.aptana.ide.scripting.events.IEventTarget;
import java.util.ArrayList;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class EventTarget
extends ScriptableObject
implements IEventTarget {
    private Hashtable _events;

    public EventTarget() {
        String[] names = new String[]{"addEventListener", "removeEventListener"};
        this.defineFunctionProperties(names, EventTarget.class, 5);
    }

    public void fireEventListeners(Event event) {
        this.fireEventListeners(event.getType(), new Object[]{event});
    }

    public void fireEventListeners(String eventType, Object[] args) {
        if (this._events != null && this._events.containsKey(eventType)) {
            ArrayList handlers = (ArrayList)this._events.get(eventType);
            int i = 0;
            while (i < handlers.size()) {
                Object eventHandler = handlers.get(i);
                if (eventHandler instanceof Function) {
                    Function f = (Function)eventHandler;
                    Scriptable scope = f.getParentScope();
                    String ID = Context.toString((Object)scope.get("__sid__", scope));
                    ScriptingEngine.getInstance().fireCallback(ID, eventHandler, args);
                }
                ++i;
            }
        }
    }

    public void addEventListener(String eventType, Object eventHandler) {
        if (this._events == null) {
            this._events = new Hashtable();
        }
        if (!this._events.containsKey(eventType)) {
            this._events.put(eventType, new ArrayList());
        }
        ArrayList handlers = (ArrayList)this._events.get(eventType);
        handlers.add(eventHandler);
    }

    public void removeEventListener(String eventType, Object eventHandler) {
        if (this._events != null && this._events.containsKey(eventType)) {
            ArrayList handlers = (ArrayList)this._events.get(eventType);
            handlers.remove(eventHandler);
        }
    }
}

