/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting;

import com.aptana.ide.scripting.Global;
import com.aptana.ide.scripting.ScriptInfo;
import com.aptana.ide.scripting.ScriptingEngine;
import com.aptana.ide.scripting.ScriptingResourceResolver;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import java.io.File;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class ScriptingHttpServer
extends HttpServer {
    private static final long serialVersionUID = 3197904170876835706L;
    private ScriptingEngine _scriptingEngine;
    private String _rootPath;

    public Global getGlobal() {
        return this._scriptingEngine.getGlobal();
    }

    public String getRootPath() {
        return this._rootPath;
    }

    public ScriptingHttpServer(ScriptingEngine scriptingEngine, String path, int port, int endPort) {
        super((IHttpResourceResolver)new ScriptingResourceResolver(new File(path)), port, endPort, 750);
        this._rootPath = path;
        ((ScriptingResourceResolver)this.getResourceResolver()).setServer(this);
        this._scriptingEngine = scriptingEngine;
    }

    public String createScriptEnvironment(String uri) {
        Context cx = Context.enter();
        Global global = this.getGlobal();
        Scriptable scope = cx.newObject((Scriptable)global);
        scope.setPrototype((Scriptable)global);
        scope.setParentScope(null);
        Script script = cx.compileString("", uri, 1, null);
        Context.exit();
        return global.storeScriptState(uri, script, scope);
    }

    public void include(String uri, String source) {
        Context cx = Context.enter();
        Global global = this.getGlobal();
        String id = global.getXrefId(uri);
        try {
            if (id != null && global.hasScriptInfo(id)) {
                ScriptInfo info = global.getScriptInfo(id);
                Scriptable scope = info.getScope();
                Script script = cx.compileString(source, uri, 1, null);
                info.addScript(script);
                script.exec(cx, scope);
            }
        }
        finally {
            Context.exit();
        }
    }

    public void removeScriptEnvironment(String uri) {
        Global global = this.getGlobal();
        String id = global.getXrefId(uri);
        if (id != null && global.hasScriptInfo(id)) {
            ScriptInfo info = global.getScriptInfo(id);
            Scriptable scope = info.getScope();
            Script[] scripts = info.getScripts();
            int i = 0;
            while (i < scripts.length) {
                Object onunload = scope.get("onunload", scope);
                if (onunload instanceof Function) {
                    Function unloadFunction = (Function)onunload;
                    Context cx = Context.enter();
                    unloadFunction.call(cx, scope, scope, new Object[0]);
                    Context.exit();
                }
                ++i;
            }
            global.removeScriptInfo(id);
        }
    }
}

