/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.wizards;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.wizards.Messages;
import com.aptana.ide.editors.wizards.SimpleNewFileWizard;
import com.aptana.ide.editors.wizards.SimpleNewWizardPage;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;

public class HtmlNewWizard
extends SimpleNewFileWizard {
    public HtmlNewWizard() {
        this.setWindowTitle(Messages.HtmlNewWizard_NewHTMLFile);
    }

    protected String getFileExtension() {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        if (store != null && store.getString("com.aptana.ide.editor.html.HTMLEDITOR_DEFAULT_EXTENSION") != null) {
            return FileUtils.ensureExtension((String)store.getString("com.aptana.ide.editor.html.HTMLEDITOR_DEFAULT_EXTENSION"));
        }
        return ".html";
    }

    protected SimpleNewWizardPage createNewFilePage(ISelection selection) {
        SimpleNewWizardPage page = new SimpleNewWizardPage(selection);
        page.setRequiredFileExtensions(new String[]{"htm", "html", FileUtils.stripExtensionPeriod((String)this.getFileExtension())});
        page.setTitle(Messages.HtmlNewWizard_HTMLFile);
        page.setDescription(Messages.HtmlNewWizard_CreateHTMLFile);
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String fileName = store.getString("com.aptana.ide.editor.html.HTMLEDITOR_INITIAL_FILE_NAME");
        page.setDefaultFileName(String.valueOf(fileName) + this.getFileExtension());
        return page;
    }

    protected String getInitialFileContents() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String contents = store.getString("com.aptana.ide.editor.html.HTMLEDITOR_INITIAL_CONTENTS");
        pw.print(contents);
        pw.close();
        return sw.toString();
    }
}

