/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.parsing.nodes;

import com.aptana.ide.editor.html.parsing.nodes.HTMLParseNode;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.nodes.IParseNodeAttribute;
import com.aptana.ide.views.outline.IResolvableItem;
import org.eclipse.ui.IEditorInput;

public class HTMLElementNode
extends HTMLParseNode
implements IResolvableItem {
    private String _id = "";
    private String _cssClass = "";
    private String _style = "";
    private boolean _isClosed;
    private IEditorInput input;

    public HTMLElementNode(Lexeme startLexeme) {
        super(3, startLexeme);
        this.setName(startLexeme.getText().substring(1));
        this.setIsClosed(false);
    }

    public String getCSSClass() {
        return this._cssClass;
    }

    public String getID() {
        return this._id;
    }

    public String getStyle() {
        return this._style;
    }

    public String getText() {
        return this.getName();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void setIsClosed(boolean value) {
        this._isClosed = value;
    }

    public void setAttribute(String name, String value) {
        name = name.toLowerCase();
        super.setAttribute(name, value);
        if (name.equals("id")) {
            this._id = value;
        } else if (name.equals("class")) {
            this._cssClass = value;
        } else if (name.equals("style")) {
            this._style = value;
        }
    }

    public IParseNodeAttribute getAttributeNode(String attributeName) {
        return super.getAttributeNode(attributeName.toLowerCase());
    }

    public void getSource(SourceWriter writer) {
        writer.printWithIndent("<").print(this.getName());
        IParseNodeAttribute[] attrs = this.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            writer.print(" ");
            attrs[i].getSource(writer);
            ++i;
        }
        if (this.hasChildren()) {
            writer.println(">");
            writer.increaseIndent();
            i = 0;
            while (i < this.getChildCount()) {
                this.getChild(i).getSource(writer);
                ++i;
            }
            writer.decreaseIndent();
            writer.printWithIndent("</").print(this.getName()).println(">");
        } else {
            IParseNodeAttribute lastAttr;
            if (this.hasAttributes() && (lastAttr = attrs[attrs.length - 1]).getQuoteType() == 0) {
                writer.print(" ");
            }
            writer.println("/>");
        }
    }

    public IEditorInput getEditorInput() {
        return this.input;
    }

    public boolean isResolvable() {
        return this.input != null;
    }

    public void setResolveInformation(IEditorInput input) {
        this.input = input;
    }

    public boolean stillHighlight() {
        return true;
    }

    public IResolvableItem getParentItem() {
        return null;
    }
}

