/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.outline;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.outline.HTMLContentProviderMessages;
import com.aptana.ide.editor.html.outline.WarningItem;
import com.aptana.ide.editor.html.parsing.nodes.HTMLDocumentNode;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editor.js.outline.JSContentProvider;
import com.aptana.ide.editor.js.outline.JSOutlineItem;
import com.aptana.ide.editor.js.parsing.JSParser;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.views.outline.IOutlineContentProviderExtension;
import com.aptana.ide.views.outline.IPathResolver;
import com.aptana.ide.views.outline.IResolvableItem;
import com.aptana.ide.views.outline.UnifiedOutlineProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLContentProvider
implements ITreeContentProvider,
IOutlineContentProviderExtension {
    private static final Object[] NO_OBJECTS = new Object[0];
    private IPathResolver resolver;
    private Map<String, Object[]> cache = new WeakHashMap<String, Object[]>();
    private HashMap<String, IPropertyChangeListener> listeners = new HashMap();
    private JSContentProvider provider;

    public Object[] getChildren(Object parentElement) {
        Object[] result = NO_OBJECTS;
        if (parentElement instanceof HTMLElementNode) {
            String attribute;
            HTMLElementNode item = (HTMLElementNode)((Object)parentElement);
            if (item.getName().equals("script") && (attribute = item.getAttribute("src")).length() > 0) {
                return this.getExternalScriptChildren(attribute, item);
            }
            result = UnifiedOutlineProvider.getInstance().getChildren((IParseNode)item, "text/html");
        }
        return result;
    }

    private Object[] getExternalScriptChildren(final String attribute, IResolvableItem parent) {
        Object[] cached = this.cache.get(attribute);
        if (cached != null) {
            return cached;
        }
        if (this.resolver == null) {
            return NO_OBJECTS;
        }
        try {
            IPropertyChangeListener propertyChangeListener = this.listeners.get(attribute);
            if (propertyChangeListener == null) {
                propertyChangeListener = new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        HTMLContentProvider.this.cache.remove(attribute);
                    }
                };
                this.resolver.addChangeListener(attribute, propertyChangeListener);
            }
            this.listeners.put(attribute, propertyChangeListener);
            String source = this.resolver.resolveSource(attribute);
            IEditorInput input = this.resolver.resolveEditorInput(attribute);
            if (source == null) {
                return new Object[]{new WarningItem(StringUtils.format((String)HTMLContentProviderMessages.HTMLContentProvider_NOT_RESOLVABLE, (String)attribute))};
            }
            try {
                JSParser ps = new JSParser();
                IParseState pState = ps.createParseState(null);
                pState.setEditState(source, source, 0, 0);
                IParseNode parse = ps.parse(pState);
                this.provider = new JSContentProvider();
                Object[] elements = this.provider.getElements((Object)parse.getChildren());
                int a = 0;
                while (a < elements.length) {
                    if (elements[a] instanceof JSOutlineItem) {
                        JSOutlineItem item = (JSOutlineItem)elements[a];
                        item.setResolveInformation(input);
                        item.setParent(parent);
                    }
                    ++a;
                }
                this.cache.put(attribute, elements);
                return elements;
            }
            catch (ParserInitializationException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)e.getMessage());
                return NO_OBJECTS;
            }
            catch (LexerException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)e.getMessage());
                return NO_OBJECTS;
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)e.getMessage());
            WarningItem warningItem = new WarningItem(e.getMessage());
            warningItem.setError(true);
            return new Object[]{warningItem};
        }
    }

    public Object getParent(Object element) {
        IParseNode result = null;
        if (element instanceof HTMLElementNode) {
            HTMLElementNode item = (HTMLElementNode)((Object)element);
            result = item.getParent();
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof HTMLElementNode) {
            HTMLElementNode elementNode = (HTMLElementNode)((Object)element);
            if (this.isScriptWithSrc(elementNode) && this.resolver != null) {
                elementNode.setResolveInformation(this.resolver.resolveEditorInput(elementNode.getAttribute("src")));
                return true;
            }
            result = elementNode.hasChildren();
        }
        return result;
    }

    private boolean isScriptWithSrc(HTMLElementNode elementNode) {
        String attribute;
        return elementNode.getName().equals("script") && (attribute = elementNode.getAttribute("src")).length() > 0;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (inputElement instanceof HTMLDocumentNode) {
            this.processNode(elements, (IParseNode)inputElement);
        }
        return elements.toArray(new Object[elements.size()]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            this.disconnectListeners();
        }
        this.cache.clear();
    }

    private void disconnectListeners() {
        if (this.resolver != null) {
            for (String key : this.listeners.keySet()) {
                IPropertyChangeListener object = this.listeners.get(key);
                this.resolver.removeChangeListener(key, object);
            }
            this.listeners.clear();
        }
    }

    private void processNode(List<Object> elements, IParseNode node) {
        switch (node.getTypeIndex()) {
            case 1: {
                int i = 0;
                while (i < node.getChildCount()) {
                    this.processNode(elements, node.getChild(i));
                    ++i;
                }
                break;
            }
            case 3: {
                elements.add(node);
                break;
            }
            default: {
                Object[] list;
                if (node.getLanguage().equals("text/html") || (list = UnifiedOutlineProvider.getInstance().getElements((Object)node)) == null) break;
                int i = 0;
                while (i < list.length) {
                    elements.add(list[i]);
                    ++i;
                }
                break block0;
            }
        }
    }

    public void setPathResolver(IPathResolver resolver) {
        if (this.resolver != null && !this.resolver.equals(resolver)) {
            this.disconnectListeners();
            this.cache.clear();
        }
        this.resolver = resolver;
    }

    public void pageActivated(IPathResolver _resolver) {
        this.setPathResolver(this.resolver);
    }

    public void pageClosed(IPathResolver _resolver) {
        this.disconnectListeners();
        this.cache.clear();
    }
}

