/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.formatting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.html.HTMLFileLanguageService;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.formatting.Messages;
import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.editor.html.parsing.HTMLUtils;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.UnifiedAutoIndentStrategy;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class HTMLAutoIndentStrategy
extends UnifiedAutoIndentStrategy {
    protected boolean isValidAutoInsertLocation(IDocument d, DocumentCommand c) {
        Lexeme l;
        boolean isString = false;
        LexemeList ll = this.getLexemeList();
        if (c.offset > 0 && ll != null && (l = ll.getLexemeFromOffset(c.offset)) != null && l.typeIndex == 44) {
            isString = true;
        }
        return HTMLUtils.insideOpenTag(c.offset, ll) && !isString;
    }

    protected char[] getAutoInsertCharacters() {
        return new char[]{'\"', '\''};
    }

    public HTMLAutoIndentStrategy(EditorFileContext context, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(context, configuration, sourceViewer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        IPreferenceStore store;
        HTMLParseState htmlParseState;
        block11: {
            if (command.text == null || command.length > 0) {
                return;
            }
            IParseState parseState = this.context.getParseState();
            htmlParseState = (HTMLParseState)parseState.getParseState("text/html");
            store = HTMLPlugin.getDefault().getPreferenceStore();
            if (store != null) {
                if (store.getString("com.aptana.ide.editor.html.AUTO_COMPLETE_CLOSE_TAGS").equals("CLOSE") && command.text.equals("/")) {
                    try {
                        LexemeList lexemeList = this.getLexemeList();
                        Lexeme current = lexemeList.getFloorLexeme(command.offset - 1);
                        if (current != null && current.getText().trim().equals("<")) {
                            Lexeme open = HTMLUtils.getPreviousUnclosedTag(current, lexemeList, htmlParseState);
                            int currentIndex = lexemeList.getLexemeIndex(current);
                            String tag = HTMLUtils.createCloseTag(open, false);
                            Lexeme next = null;
                            if (currentIndex + 1 < lexemeList.size()) {
                                next = lexemeList.get(currentIndex + 1);
                            }
                            if (next == null || next != null && !next.getText().equals(">")) {
                                tag = String.valueOf(tag) + ">";
                            }
                            if (tag != null) {
                                command.text = tag = tag.substring(1);
                                command.shiftsCaret = false;
                                command.caretOffset = command.offset + tag.length();
                                this.hideContentAssistPopup();
                                return;
                            }
                        }
                        break block11;
                    }
                    catch (Exception ex) {
                        IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.HTMLAutoIndentStrategy_ERR_ClosingTag, (Throwable)ex);
                        return;
                    }
                }
                if (store.getString("com.aptana.ide.editor.html.AUTO_COMPLETE_CLOSE_TAGS").equals("OPEN") && command.text.equals(">") && HTMLAutoIndentStrategy.closeTag(command, this.getLexemeList(), htmlParseState)) {
                    return;
                }
            }
        }
        if (store != null && store.getBoolean("com.aptana.ide.editor.html.AUTO_INDENT_ON_CARRIAGE_RETURN") && UnifiedConfiguration.isNewlineString((String)command.text) && this.indentNextTag(document, command, htmlParseState)) {
            return;
        }
        super.customizeDocumentCommand(document, command);
    }

    protected LexemeList getLexemeList() {
        IFileLanguageService ls = this.getLanguageService();
        return ls.getFileContext().getLexemeList();
    }

    public static boolean closeTag(DocumentCommand command, LexemeList ll, HTMLParseState parseState) {
        Lexeme lexeme = ll.getFloorLexeme(command.offset);
        if (lexeme == null) {
            return false;
        }
        if (lexeme.getText().equals("/")) {
            return false;
        }
        if (lexeme.getText().equals(">")) {
            return false;
        }
        if (HTMLUtils.insideQuotedString(lexeme, command.offset)) {
            return false;
        }
        Lexeme startLexeme = HTMLUtils.getTagOpenLexeme(command.offset, ll);
        if (startLexeme == null) {
            return false;
        }
        String replaceText = HTMLUtils.getOpenTagName(startLexeme, command.offset);
        if (HTMLUtils.isStartTagBalanced(startLexeme, ll, parseState)) {
            return false;
        }
        if (parseState == null || !parseState.isEmptyTagType(replaceText)) {
            command.text = ">" + HTMLUtils.createCloseTag(replaceText, true);
            command.shiftsCaret = false;
            command.caretOffset = command.offset + 1;
        }
        return true;
    }

    protected IFileLanguageService getLanguageService() {
        HTMLFileLanguageService ls = (HTMLFileLanguageService)this.context.getLanguageService("text/html");
        return ls;
    }

    private boolean indentNextTag(IDocument d, DocumentCommand c, HTMLParseState parseState) {
        IFileLanguageService ls = this.getLanguageService();
        LexemeList ll = ls.getFileContext().getLexemeList();
        if (ll == null) {
            return false;
        }
        int floorIndex = ll.getLexemeFloorIndex(c.offset - 1);
        if (floorIndex < 0) {
            return false;
        }
        Lexeme lexeme = ll.get(floorIndex);
        if (lexeme == null) {
            return false;
        }
        if (!lexeme.getText().equals(">")) {
            return false;
        }
        int position = floorIndex - 1;
        while (position >= 0) {
            lexeme = ll.get(position);
            if (lexeme == null) {
                return false;
            }
            if (lexeme.typeIndex == 30 || lexeme.typeIndex == 39 || lexeme.typeIndex == 27) {
                return false;
            }
            if (lexeme.typeIndex == 41) break;
            --position;
        }
        String replaceText = lexeme.getText().substring(1);
        if (lexeme != null && parseState != null && parseState.isEmptyTagType(replaceText)) {
            return false;
        }
        String returnVal = c.text;
        String spaces = this.getIndentForCurrentLine(d, c);
        String newIndent = "\t";
        if (this.configuration instanceof UnifiedConfiguration) {
            UnifiedConfiguration uc = (UnifiedConfiguration)this.configuration;
            newIndent = uc.getIndent();
        }
        String nextText = String.valueOf(returnVal) + spaces;
        int ceilingIndex = ll.getLexemeCeilingIndex(c.offset);
        if (ceilingIndex < 0) {
            nextText = "";
        } else {
            Lexeme nextLexeme = ll.get(ceilingIndex);
            if (nextLexeme.typeIndex != 27) {
                nextText = "";
            }
        }
        String beginText = String.valueOf(returnVal) + spaces + newIndent;
        c.text = String.valueOf(beginText) + nextText;
        c.shiftsCaret = false;
        c.caretOffset = c.offset + beginText.length();
        return true;
    }

    public IPreferenceStore getPreferenceStore() {
        return HTMLPlugin.getDefault().getPreferenceStore();
    }
}

