/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.core.builder.IProblem;
import com.aptana.ide.core.builder.Warning;
import com.aptana.ide.editor.html.HTMLBuildParticipant;
import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.editor.html.parsing.HTMLUtils;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnclosedTagHTMLBuildParticipant
extends HTMLBuildParticipant {
    public void build(BuildContext context, IProgressMonitor monitor) {
        if (!this.isHTMLFile(context)) {
            return;
        }
        IParseNode root = context.getRootNode();
        List<IProblem> problems = this.walk(context, root);
        problems.addAll(this.findUnopenedLexemes(context));
        context.recordNewProblems(problems);
    }

    private Collection<? extends IProblem> findUnopenedLexemes(BuildContext context) {
        Lexeme[] lexes;
        ArrayList<Warning> problems = new ArrayList<Warning>();
        LexemeList list = context.getLexemeList();
        if (list == null) {
            return problems;
        }
        Lexeme[] lexemeArray = lexes = list.toArray();
        int n = lexes.length;
        int n2 = 0;
        while (n2 < n) {
            Lexeme lex = lexemeArray[n2];
            if (lex != null && lex.getLanguage().equals("text/html") && HTMLUtils.isEndTag(lex) && this.isUnopened(context, lex)) {
                problems.add(new Warning(3, context.getFile().getFullPath().toPortableString(), this.getLineNumber(context, lex), lex.getStartingOffset(), lex.getEndingOffset(), "Unopened tag '" + lex.getText() + "'"));
            }
            ++n2;
        }
        return problems;
    }

    private List<IProblem> walk(BuildContext context, IParseNode root) {
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        if (root == null) {
            return problems;
        }
        IParseNode[] children = root.getChildren();
        if (children == null) {
            return problems;
        }
        IParseNode[] iParseNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            HTMLElementNode elementNode;
            IParseNode node = iParseNodeArray[n2];
            if (node instanceof HTMLElementNode && HTMLUtils.isStartTag((elementNode = (HTMLElementNode)node).getStartingLexeme()) && !this.isClosed(context, elementNode)) {
                problems.add((IProblem)new Warning(3, context.getFile().getFullPath().toPortableString(), this.getLineNumber(context, (IParseNode)elementNode), elementNode.getStartingOffset(), elementNode.getEndingOffset(), "Unclosed tag '" + elementNode.getName() + "'"));
            }
            problems.addAll(this.walk(context, node));
            ++n2;
        }
        return problems;
    }

    private boolean isUnopened(BuildContext context, Lexeme lexeme) {
        return !HTMLUtils.isEndTagBalanced(lexeme, context.getLexemeList(), (HTMLParseState)context.getParseState());
    }

    private boolean isClosed(BuildContext context, HTMLElementNode elementNode) {
        if (elementNode.isClosed()) {
            return true;
        }
        return HTMLUtils.isStartTagBalanced(elementNode.getStartingLexeme(), context.getLexemeList(), (HTMLParseState)context.getParseState());
    }
}

