/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.core.builder.IProblem;
import com.aptana.ide.core.builder.Warning;
import com.aptana.ide.editor.html.HTMLBuildParticipant;
import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAttributeHTMLBuildParticipant
extends HTMLBuildParticipant {
    private static Map<String, String[]> REQUIRED_ATTRIBUTES = new HashMap<String, String[]>();

    static {
        REQUIRED_ATTRIBUTES.put("img", new String[]{"alt", "src"});
        REQUIRED_ATTRIBUTES.put("basefont", new String[]{"size"});
        REQUIRED_ATTRIBUTES.put("applet", new String[]{"width", "height"});
        REQUIRED_ATTRIBUTES.put("style", new String[]{"type"});
        REQUIRED_ATTRIBUTES.put("script", new String[]{"type"});
        REQUIRED_ATTRIBUTES.put("textarea", new String[]{"rows", "cols"});
        REQUIRED_ATTRIBUTES.put("area", new String[]{"alt"});
        REQUIRED_ATTRIBUTES.put("param", new String[]{"name"});
        REQUIRED_ATTRIBUTES.put("map", new String[]{"name"});
        REQUIRED_ATTRIBUTES.put("bdo", new String[]{"dir"});
        REQUIRED_ATTRIBUTES.put("meta", new String[]{"content"});
        REQUIRED_ATTRIBUTES.put("optgroup", new String[]{"label"});
        REQUIRED_ATTRIBUTES.put("form", new String[]{"action"});
    }

    public void build(BuildContext context, IProgressMonitor monitor) {
        if (!this.isHTMLFile(context)) {
            return;
        }
        IParseNode root = context.getRootNode();
        List<IProblem> problems = this.walk(context, root);
        context.recordNewProblems(problems);
    }

    private List<IProblem> walk(BuildContext context, IParseNode root) {
        IParseNode[] children;
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        if (root == null) {
            return problems;
        }
        IParseNode[] iParseNodeArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode node = iParseNodeArray[n2];
            if (node instanceof HTMLElementNode) {
                HTMLElementNode elementNode = (HTMLElementNode)node;
                Set<String> missingAttributes = this.getMissingAttributes(elementNode);
                for (String attributeName : missingAttributes) {
                    problems.add((IProblem)new Warning(2, context.getFile().getFullPath().toPortableString(), this.getLineNumber(context, (IParseNode)elementNode), elementNode.getStartingOffset(), elementNode.getEndingOffset(), "Missing required attribute '" + attributeName + "'"));
                }
            }
            problems.addAll(this.walk(context, node));
            ++n2;
        }
        return problems;
    }

    private Set<String> getMissingAttributes(HTMLElementNode elementNode) {
        String tagName = elementNode.getName();
        if (!REQUIRED_ATTRIBUTES.containsKey(tagName)) {
            return Collections.emptySet();
        }
        HashSet<String> missingAttributes = new HashSet<String>();
        String[] stringArray = REQUIRED_ATTRIBUTES.get(tagName);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!this.containsAttribute(elementNode, attribute)) {
                missingAttributes.add(attribute);
            }
            ++n2;
        }
        return missingAttributes;
    }

    private boolean containsAttribute(HTMLElementNode elementNode, String attrName) {
        if (elementNode == null) {
            return false;
        }
        IParseNodeAttribute[] attrs = elementNode.getAttributes();
        if (attrs == null) {
            return false;
        }
        IParseNodeAttribute[] iParseNodeAttributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNodeAttribute attr = iParseNodeAttributeArray[n2];
            String attributeName = attr.getName();
            if (attributeName.equalsIgnoreCase(attrName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

