/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.IBrowserDecorator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowserExtensionLoader {
    private static List<IConfigurationElement> browserList = null;
    private static List<String> allBrowsers = null;
    private static List<IConfigurationElement> showList = new ArrayList<IConfigurationElement>();
    private static IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE".equals(event.getProperty())) {
                BrowserExtensionLoader.computeShowList();
            }
        }
    };
    private static Map<String, IBrowserDecorator> decorators = null;
    private static String OS = Platform.getOS();

    private BrowserExtensionLoader() {
    }

    public static String getBrowserLabel(IConfigurationElement browserElement) {
        String label = null;
        boolean found = false;
        IConfigurationElement[] ce = browserElement.getChildren("label");
        int k = 0;
        while (k < ce.length && !found) {
            if (ce[k].getAttribute("os") != null && ce[k].getAttribute("value") != null && OS.equals(ce[k].getAttribute("os"))) {
                label = ce[k].getAttribute("value");
                found = true;
            }
            ++k;
        }
        return label;
    }

    public static void getDecorator(ContributedBrowser browser, Listener listener) {
        String name;
        if (decorators == null) {
            decorators = new HashMap<String, IBrowserDecorator>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ce = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    if ("decorator".equals(ce[j].getName())) {
                        String decoratorClass = ce[j].getAttribute("class");
                        String browserClassName = ce[j].getAttribute("browser");
                        if (decoratorClass != null && browserClassName != null) {
                            try {
                                Object obj = ce[j].createExecutableExtension("class");
                                if (obj instanceof IBrowserDecorator) {
                                    decorators.put(browserClassName, (IBrowserDecorator)obj);
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (browser != null && listener != null && (name = browser.getBrowserType()) != null && decorators.containsKey(name)) {
            decorators.get(name).getBrowserDecorator(browser, listener);
        }
    }

    private static void computeShowList() {
        showList.clear();
        String browserString = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE");
        String[] browsers_names = browserString.split(",");
        IConfigurationElement safari = null;
        int i = 0;
        while (i < browserList.size()) {
            IConfigurationElement element = browserList.get(i);
            String name = BrowserExtensionLoader.getBrowserLabel(element);
            if (safari == null && "Safari".equals(name)) {
                safari = element;
            }
            if (name != null) {
                boolean show = false;
                int k = 0;
                while (k < browsers_names.length && !show) {
                    if (name.equals(browsers_names[k])) {
                        show = true;
                    }
                    ++k;
                }
                if (show) {
                    showList.add(element);
                }
            }
            ++i;
        }
        if (OS.equals("macosx") && showList.size() == 1) {
            IConfigurationElement element = showList.get(0);
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            store.removePropertyChangeListener(propertyChangeListener);
            if (BrowserExtensionLoader.getBrowserLabel(element).equals("Firefox")) {
                if (safari != null) {
                    showList.add(0, safari);
                    store.setValue("com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE", String.valueOf(browserString) + ",Safari");
                } else {
                    showList.clear();
                    store.setValue("com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE", "");
                }
            }
            store.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public static List<IConfigurationElement> getBrowsers(String[] names) {
        ArrayList<IConfigurationElement> browsers = new ArrayList<IConfigurationElement>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                if ("browser".equals(ce[j].getName())) {
                    String browserClass = ce[j].getAttribute("class");
                    String name = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                    if (browserClass != null && name != null) {
                        int k = 0;
                        while (k < names.length) {
                            if (name.equals(names[k])) {
                                browsers.add(ce[j]);
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return browsers;
    }

    public static List<IConfigurationElement> loadBrowsers() {
        if (browserList == null) {
            browserList = new ArrayList<IConfigurationElement>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
            IExtension[] extensions = ep.getExtensions();
            HTMLPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(propertyChangeListener);
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ce = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    String browserClass = ce[j].getAttribute("class");
                    String name = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                    if (browserClass != null && name != null) {
                        browserList.add(ce[j]);
                    }
                    ++j;
                }
                ++i;
            }
            Collections.sort(browserList, new Comparator<IConfigurationElement>(){

                @Override
                public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                    String name1 = BrowserExtensionLoader.getBrowserLabel(o1);
                    String name2 = BrowserExtensionLoader.getBrowserLabel(o2);
                    if (name1 != null && name2 != null) {
                        if (Platform.getOS().equals("macosx")) {
                            return name2.compareTo(name1);
                        }
                        return name1.compareTo(name2);
                    }
                    return 0;
                }
            });
            BrowserExtensionLoader.computeShowList();
        }
        if (browserList != null) {
            int j = 0;
            while (j < browserList.size()) {
                IConfigurationElement element = browserList.get(j);
                String name = BrowserExtensionLoader.getBrowserLabel(element);
                IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)StringUtils.format((String)Messages.BrowserExtensionLoader_INF_Preview, (Object[])new String[]{String.valueOf(j), name}));
                ++j;
            }
        }
        return showList;
    }

    public static Image getBrowserImage(String label) {
        Image image = null;
        if (Messages.BrowserExtensionLoader_IPhone.equalsIgnoreCase(label)) {
            image = HTMLPlugin.getImage("icons/iphone-nature.png");
        } else if (Messages.BrowserExtensionLoader_Firefox.equalsIgnoreCase(label)) {
            image = HTMLPlugin.getImage("icons/firefox_icon.png");
        } else if (Messages.BrowserExtensionLoader_IE.equalsIgnoreCase(label)) {
            image = HTMLPlugin.getImage("icons/ie_icon.png");
        } else if (Messages.BrowserExtensionLoader_Default.equalsIgnoreCase(label)) {
            image = HTMLPlugin.getImage("icons/firefox_icon.png");
        } else if (Messages.BrowserExtensionLoader_Safari.equalsIgnoreCase(label)) {
            image = HTMLPlugin.getImage("icons/safari_icon.png");
        }
        return image;
    }

    public static List getAllBrowserLabels() {
        if (allBrowsers == null) {
            allBrowsers = new ArrayList<String>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ce = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    String browserClass = ce[j].getAttribute("class");
                    String name = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                    if (browserClass != null && name != null) {
                        allBrowsers.add(name);
                    }
                    ++j;
                }
                ++i;
            }
            Collections.sort(allBrowsers, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    String name1 = o1;
                    String name2 = o2;
                    if (name1 != null && name2 != null) {
                        return name1.compareTo(name2);
                    }
                    return 0;
                }
            });
        }
        return allBrowsers;
    }
}

