/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.efs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;

class FileTree
extends org.eclipse.core.filesystem.provider.FileTree {
    private static final IFileStore[] EMPTY_FILE_STORE_ARRAY = new IFileStore[0];
    private static final IFileInfo[] EMPTY_FILE_INFO_ARRAY = new IFileInfo[0];
    private Map<IFileStore, IFileStore[]> treeMap = new HashMap<IFileStore, IFileStore[]>();
    private Map<IFileStore, IFileInfo> infoMap = new HashMap<IFileStore, IFileInfo>();

    FileTree(IFileStore treeRoot) {
        super(treeRoot);
    }

    void addChildren(IFileStore parent, IFileStore[] stores, IFileInfo[] infos) {
        int i = 0;
        while (i < stores.length) {
            this.infoMap.put(stores[i], infos[i]);
            ++i;
        }
        this.treeMap.put(parent, stores);
    }

    public IFileInfo[] getChildInfos(IFileStore store) {
        IFileStore[] result = this.treeMap.get(store);
        if (result != null) {
            ArrayList<IFileInfo> list = new ArrayList<IFileInfo>();
            IFileStore[] iFileStoreArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore file = iFileStoreArray[n2];
                list.add(this.infoMap.get(file));
                ++n2;
            }
            return list.toArray(new IFileInfo[list.size()]);
        }
        return EMPTY_FILE_INFO_ARRAY;
    }

    public IFileStore[] getChildStores(IFileStore store) {
        IFileStore[] result = this.treeMap.get(store);
        if (result != null) {
            return result;
        }
        return EMPTY_FILE_STORE_ARRAY;
    }

    public IFileInfo getFileInfo(IFileStore store) {
        IFileInfo result = this.infoMap.get(store);
        if (result != null) {
            return result;
        }
        return new FileInfo(store.getName());
    }
}

