/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.LocalConnectionPoint;
import com.aptana.ide.core.io.WorkspaceConnectionPoint;
import com.aptana.ide.core.io.efs.EFSUtils;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public final class ConnectionPointUtils {
    private ConnectionPointUtils() {
    }

    public static IConnectionPoint findConnectionPoint(URI uri) {
        IConnectionPoint[] iConnectionPointArray = CoreIOPlugin.getConnectionPointManager().getConnectionPoints();
        int n = iConnectionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionPoint i = iConnectionPointArray[n2];
            if (i.getRootURI().equals(uri)) {
                return i;
            }
            ++n2;
        }
        return null;
    }

    public static IConnectionPoint[] getRemoteConnectionPoints() {
        ArrayList<IConnectionPoint> list = new ArrayList<IConnectionPoint>();
        IConnectionPoint[] iConnectionPointArray = CoreIOPlugin.getConnectionPointManager().getConnectionPoints();
        int n = iConnectionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionPoint i = iConnectionPointArray[n2];
            if (ConnectionPointUtils.isRemote(i)) {
                list.add(i);
            }
            ++n2;
        }
        return list.toArray(new IConnectionPoint[list.size()]);
    }

    public static boolean isLocal(IConnectionPoint connectionPoint) {
        return connectionPoint instanceof LocalConnectionPoint;
    }

    public static boolean isWorkspace(IConnectionPoint connectionPoint) {
        return connectionPoint instanceof WorkspaceConnectionPoint;
    }

    public static boolean isRemote(IConnectionPoint connectionPoint) {
        return connectionPoint instanceof IBaseRemoteConnectionPoint;
    }

    public static IConnectionPoint createLocalConnectionPoint(IPath path) {
        LocalConnectionPoint connectionPoint = new LocalConnectionPoint(path);
        connectionPoint.setName(path.toPortableString());
        return connectionPoint;
    }

    public static IConnectionPoint createWorkspaceConnectionPoint(IContainer container) {
        WorkspaceConnectionPoint connectionPoint = new WorkspaceConnectionPoint(container);
        connectionPoint.setName(container instanceof IProject ? container.getName() : container.getFullPath().toPortableString());
        return connectionPoint;
    }

    public static IConnectionPoint findOrCreateLocalConnectionPoint(IPath path) {
        IConnectionPoint connectionPoint = ConnectionPointUtils.findConnectionPoint(EFSUtils.getFileStore(path.toFile()).toURI());
        if (connectionPoint == null) {
            connectionPoint = ConnectionPointUtils.createLocalConnectionPoint(path);
        }
        return connectionPoint;
    }

    public static IConnectionPoint findOrCreateWorkspaceConnectionPoint(IContainer container) {
        IConnectionPoint connectionPoint = ConnectionPointUtils.findConnectionPoint(EFSUtils.getFileStore((IResource)container).toURI());
        if (connectionPoint == null) {
            connectionPoint = ConnectionPointUtils.createWorkspaceConnectionPoint(container);
        }
        return connectionPoint;
    }
}

