/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.resources;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.IUniformResourceChangeListener;
import com.aptana.ide.internal.core.resources.MarkerInfo;
import com.aptana.ide.internal.core.resources.MarkerManager;
import com.aptana.ide.internal.core.resources.UniformResourceMarker;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public final class MarkerUtils {
    private static final IMarker[] NO_MARKERS = new IMarker[0];

    private MarkerUtils() {
    }

    public static IMarker createMarker(IUniformResource resource, Map attributes, String markerType) throws CoreException {
        MarkerInfo info = new MarkerInfo();
        info.setType(markerType);
        info.setCreationTime(System.currentTimeMillis());
        if (attributes != null) {
            try {
                Method m = ((Object)((Object)info)).getClass().getDeclaredMethod("setAttributes", Map.class, Boolean.class);
                if (m != null) {
                    m.invoke((Object)info, attributes, true);
                } else {
                    m = ((Object)((Object)info)).getClass().getDeclaredMethod("setAttributes", Map.class);
                    m.invoke((Object)info, attributes);
                }
            }
            catch (Exception e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
            }
        }
        MarkerUtils.getMarkerManager().add(resource, info);
        return new UniformResourceMarker(resource, info.getId());
    }

    public static IMarker createMarkerForExternalResource(IUniformResource resource, Map attributes, String markerType) throws CoreException {
        IMarker marker = MarkerUtils.createMarker(resource, attributes, markerType);
        MarkerUtils.getMarkerManager().externalResourceChanged(resource);
        return marker;
    }

    public static IMarker[] findMarkers(IUniformResource resource, String type, boolean includeSubtypes) {
        MarkerManager markerManager = MarkerUtils.getMarkerManager();
        MarkerInfo[] list = markerManager.findMarkersInfo(resource, type, includeSubtypes);
        ArrayList<UniformResourceMarker> result = new ArrayList<UniformResourceMarker>();
        int i = 0;
        while (i < list.length) {
            result.add(new UniformResourceMarker(resource, list[i].getId()));
            ++i;
        }
        if (result.size() == 0) {
            return NO_MARKERS;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    private static MarkerManager getMarkerManager() {
        return MarkerManager.getInstance();
    }

    public static void addResourceChangeListener(IUniformResourceChangeListener listener) {
        MarkerUtils.getMarkerManager().addResourceChangeListener(listener);
    }

    public static void removeResourceChangeListener(IUniformResourceChangeListener listener) {
        MarkerUtils.getMarkerManager().removeResourceChangeListener(listener);
    }

    public static void setCharEnd(Map attributes, int charEnd) {
        attributes.put("charEnd", new Integer(charEnd));
    }

    public static void setCharStart(Map attributes, int charStart) {
        attributes.put("charStart", new Integer(charStart));
    }

    public static void setMessage(Map attributes, String message) {
        attributes.put("message", message);
    }

    public static void setLineNumber(Map attributes, int line) {
        attributes.put("lineNumber", new Integer(line));
    }
}

