/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class URLStatusTracker {
    private static URLStatusTracker fURLErrors = null;
    private List<Listener> fListeners = new ArrayList<Listener>();
    private Map<URL, Integer> fStatus = new HashMap<URL, Integer>();

    public void addListener(Listener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.fListeners.clear();
    }

    public void setStatus(URL url, int status) {
        Integer oldStatus = this.fStatus.get(url);
        if (oldStatus == null || oldStatus != status) {
            this.fStatus.put(url, new Integer(status));
            this.fireStatusUpdated(url, status);
        }
    }

    public static URLStatusTracker getInstance() {
        if (fURLErrors == null) {
            fURLErrors = new URLStatusTracker();
        }
        return fURLErrors;
    }

    private void fireStatusUpdated(URL url, int status) {
        for (Listener listener : this.fListeners) {
            listener.statusUpdated(url, status);
        }
    }

    private URLStatusTracker() {
    }

    public static interface Listener {
        public void statusUpdated(URL var1, int var2);
    }
}

