/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.ILoggable;
import com.aptana.ide.core.ILogger;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.LoggerAdapater;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.model.IServiceProvider;
import com.aptana.ide.core.model.IServiceRequest;
import com.aptana.ide.core.model.IServiceResponse;
import com.aptana.ide.core.model.Messages;
import com.aptana.ide.core.model.SimpleServiceResponse;
import com.aptana.ide.core.model.URLStatusTracker;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class RESTServiceProvider
implements IServiceProvider,
ILoggable {
    public static final String DEBUG_HOST;
    private static final String PROPERTY_KEY = "SiteManagerSelection";
    public static final String LOCATION_HEADER = "Location";
    public static final String AUTHORIZATION_HEADER = "Aptana-Authorization";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String ACCEPT_HEADER = "Accept";
    private SSLContext sslContext;
    private ILogger logger = new LoggerAdapater(){

        public void logError(String message) {
            AptanaCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "com.aptana.ide.core", 1, message, null));
        }
    };
    private static List<Listener> listeners;
    private static int maxLossageSize;
    private static StringBuffer lossage;

    static {
        IEclipsePreferences prefs = new DefaultScope().getNode("org.eclipse.core.resources");
        prefs.putBoolean(PROPERTY_KEY, true);
        boolean useProduction = true;
        if (useProduction) {
            String debugHost = System.getProperty("DEBUG_HOST");
            if (debugHost == null || debugHost.length() == 0) {
                debugHost = "cloudmanager.aptana.com";
            }
            DEBUG_HOST = debugHost;
        } else {
            DEBUG_HOST = "acotak-staging.aptana.com";
        }
        listeners = new ArrayList<Listener>();
        maxLossageSize = Integer.getInteger("com.aptana.ide.core.model.maxLossageSize", 524288);
        lossage = new StringBuffer();
    }

    public RESTServiceProvider() {
        try {
            if (DEBUG_HOST != null) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        int i = 0;
                        while (i < certs.length) {
                            String issuer = certs[i].getIssuerDN().getName();
                            if (issuer.trim().equals("EMAILADDRESS=cwilliams@aptana.com, CN=" + DEBUG_HOST + ", OU=Aptana Cloud, O=\"Aptana, Inc.\", L=San Mateo, ST=California, C=US")) {
                                return;
                            }
                            ++i;
                        }
                    }
                }};
                this.sslContext = SSLContext.getInstance("SSL");
                this.sslContext.init(null, trustAllCerts, new SecureRandom());
            }
        }
        catch (Exception e) {
            this.logMessage(e.getMessage());
            this.sslContext = null;
        }
    }

    public static void addListener(Listener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeListener(Listener listener) {
        listeners.remove(listener);
    }

    private void fireAuthenticationFailed(User user) {
        for (Listener listener : listeners) {
            listener.authenticationFailed(user);
        }
    }

    private void fireCorrectAuthentication() {
        for (Listener listener : listeners) {
            listener.correctAuthentication();
        }
    }

    private IServiceResponse getResponse(URLConnection rawResponse) {
        SimpleServiceResponse response;
        block17: {
            int status = -1;
            response = null;
            try {
                User signedInUser;
                if (rawResponse instanceof HttpURLConnection) {
                    try {
                        status = ((HttpURLConnection)rawResponse).getResponseCode();
                        URLStatusTracker.getInstance().setStatus(rawResponse.getURL(), status);
                    }
                    catch (IOException e) {
                        if (!(e instanceof UnknownHostException)) {
                            this.logMessage("Error occured reading status from response for location: " + rawResponse.getURL() + " " + e.getMessage());
                        }
                        throw e;
                    }
                }
                if (status == 401 && (signedInUser = AptanaUser.getSignedInUser()) != null && signedInUser.hasCredentials()) {
                    this.fireAuthenticationFailed(signedInUser);
                    IdeLog.logImportant(AptanaCorePlugin.getDefault(), Messages.getString("RESTServiceProvider.AuthenticationFailedSigningOut"));
                    AptanaUser.signOut();
                    return new SimpleServiceResponse("", "", "", 401);
                }
                String location = rawResponse.getHeaderField(LOCATION_HEADER);
                if (location != null) {
                    try {
                        response = new SimpleServiceResponse(rawResponse.getContentType(), location, new URL(location), status);
                        this.logMessage("Location found in response: " + location);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.logMessage("Error creating URL from Location header: " + location);
                    }
                    break block17;
                }
                String responseBody = null;
                responseBody = rawResponse instanceof HttpURLConnection ? this.getResponseBody((HttpURLConnection)rawResponse) : this.getResponseBody(rawResponse.getInputStream());
                response = new SimpleServiceResponse(rawResponse.getContentType(), responseBody, responseBody, status);
            }
            catch (UnknownHostException unknownHostException) {
                return new SimpleServiceResponse("", "", "", -200);
            }
            catch (IOException e) {
                this.logMessage("IOException on getResponse for location: " + rawResponse.getURL() + " " + e.getMessage());
                if (!(rawResponse instanceof HttpURLConnection)) break block17;
                try {
                    InputStream stream = ((HttpURLConnection)rawResponse).getErrorStream();
                    if (stream != null) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                        StringBuffer buffer = new StringBuffer();
                        String line = reader.readLine();
                        while (line != null) {
                            buffer.append(line);
                            buffer.append('\n');
                            line = reader.readLine();
                        }
                        response = new SimpleServiceResponse(rawResponse.getContentType(), buffer.toString(), buffer.toString(), status);
                    }
                }
                catch (Exception exception) {
                    this.logMessage("Error reading error stream from response for location: " + rawResponse.getURL() + " " + e.getMessage());
                }
            }
        }
        this.appendResponseLossage(rawResponse, response);
        return response;
    }

    private String getResponseBody(HttpURLConnection rawResponse) throws IOException {
        try {
            return this.getResponseBody(rawResponse.getInputStream());
        }
        catch (IOException e) {
            this.logMessage("Error occured reading from response stream for location: " + rawResponse.getURL() + " " + e.getMessage());
            try {
                return this.getResponseBody(rawResponse.getErrorStream());
            }
            catch (IOException e2) {
                this.logMessage("Error occured reading from response error stream for location: " + rawResponse.getURL() + " " + e2.getMessage());
                throw e2;
            }
        }
    }

    private String getResponseBody(InputStream stream) throws IOException {
        if (stream == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream));
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return buffer.toString();
    }

    private void logMessage(String message) {
        if (this.getLogger() != null) {
            this.getLogger().logError(message);
        }
    }

    public int getTimeout() {
        return 40000;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public IServiceResponse callService(URL location, IServiceRequest request) {
        try {
            if (this.sslContext != null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(this.sslContext.getSocketFactory());
            }
        }
        catch (Exception e) {
            this.logMessage(e.getMessage());
        }
        if (request == null) {
            return null;
        }
        this.appendRequestLossage(location, request);
        URLConnection connection = null;
        IServiceResponse response = null;
        try {
            this.fireCorrectAuthentication();
            connection = location.openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(this.getTimeout());
            if (connection instanceof HttpURLConnection) {
                Map<String, String> requestProperties;
                HttpURLConnection httpConn = (HttpURLConnection)connection;
                connection.setReadTimeout(this.getTimeout());
                connection.setDoInput(true);
                httpConn.addRequestProperty("Cache-Control", "no-cache");
                if (request.getRequestType() != null) {
                    httpConn.setRequestMethod(request.getRequestType());
                }
                if (request.getAuthentication() != null) {
                    connection.addRequestProperty(AUTHORIZATION_HEADER, request.getAuthentication());
                }
                if (request.getContentType() != null) {
                    connection.addRequestProperty(CONTENT_TYPE_HEADER, request.getContentType());
                }
                if (request.getAccept() != null) {
                    connection.addRequestProperty(ACCEPT_HEADER, request.getAccept());
                }
                if ((requestProperties = request.getRequestProperties()) != null) {
                    for (String name : requestProperties.keySet()) {
                        connection.addRequestProperty(name, requestProperties.get(name));
                    }
                }
                if (request.containsBody()) {
                    connection.setDoOutput(true);
                    OutputStream outputStream = connection.getOutputStream();
                    OutputStreamWriter writer = null;
                    writer = "application/xml".equals(request.getContentType()) ? new OutputStreamWriter(outputStream, "UTF-8") : new OutputStreamWriter(outputStream);
                    writer.write(String.valueOf(request.getContents()) + "\n");
                    writer.flush();
                }
            }
        }
        catch (Exception e) {
            this.logMessage("Error occured streaming request:" + e.getMessage());
        }
        if (connection != null) {
            response = this.getResponse(connection);
        }
        return response;
    }

    public static String getLossage() {
        return lossage.toString();
    }

    private void appendRequestLossage(URL location, IServiceRequest request) {
        if (location != null) {
            this.appendlnLossage("Request URL: " + location);
        }
        if (request != null) {
            String contents;
            this.appendlnLossage("Request Type: " + request.getRequestType());
            this.appendlnLossage("Request Content Type: " + request.getContentType());
            this.appendlnLossage("Request Authentication: " + request.getAuthentication());
            this.appendlnLossage("Request Accept: " + request.getAccept());
            if (request.containsBody() && (contents = request.getContents()) != null) {
                this.appendlnLossage("Request Body:");
                this.appendlnLossage(StringUtils.getPublishableMessage(request.getContents()));
            }
        }
    }

    private void appendResponseLossage(URLConnection rawResponse, IServiceResponse response) {
        if (rawResponse != null) {
            this.appendlnLossage("Response Request URL: " + rawResponse.getURL());
            this.appendlnLossage("Response Content Type: " + rawResponse.getContentType());
            this.appendlnLossage("Response Content Length: " + rawResponse.getContentLength());
            this.appendlnLossage("Response Content Encoding: " + rawResponse.getContentEncoding());
            this.appendlnLossage("Response Date: " + rawResponse.getDate());
            this.appendlnLossage("Response Last Modified: " + rawResponse.getLastModified());
            this.appendlnLossage("Response Expiration: " + rawResponse.getExpiration());
            this.appendlnLossage("Response If Modified Since: " + rawResponse.getIfModifiedSince());
            Map<String, List<String>> headerFields = rawResponse.getHeaderFields();
            for (String fieldName : headerFields.keySet()) {
                this.appendlnLossage("Response Header field '" + fieldName + "'=" + headerFields.get(fieldName));
            }
            this.appendlnLossage("Response Connect Timeout: " + rawResponse.getConnectTimeout());
        }
        if (response != null) {
            this.appendlnLossage("Response Status: " + response.getStatus());
            this.appendlnLossage("Response Content Type: " + response.getContentType());
            String contents = response.getContents();
            if (contents != null) {
                this.appendlnLossage("Response Content:");
                this.appendlnLossage(StringUtils.getPublishableMessage(contents));
            }
        }
    }

    private void appendlnLossage(String appendix) {
        this.appendLossage(String.valueOf(appendix) + "\n");
    }

    private void appendLossage(String appendix) {
        int length = appendix.length();
        if (length > maxLossageSize) {
            lossage.setLength(0);
            lossage.append(appendix.substring(length - maxLossageSize));
        } else {
            int lossageLength = lossage.length();
            int totalLength = lossageLength + length;
            if (totalLength > maxLossageSize) {
                lossage.delete(0, totalLength - maxLossageSize);
                lossage.append(appendix);
            } else {
                lossage.append(appendix);
            }
        }
    }

    public static interface Listener {
        public void authenticationFailed(User var1);

        public void correctAuthentication();
    }
}

