/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.builder;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.builder.BuildContext;
import com.aptana.ide.core.builder.BuildParticipant;
import com.aptana.ide.core.builder.IProblem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedProjectBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.aptana.ide.core.unifiedBuilder";
    private static final String BUILD_PARTICIPANT_EXTENSION_POINT_ID = "buildParticipants";
    private static final boolean DEBUG = false;
    private static final Integer DEFAULT_PRIORITY = 0;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (this.getProject() == null || !this.getProject().isAccessible()) {
            return new IProject[0];
        }
        List<BuildParticipant> participants = this.getBuildParticipants();
        List<BuildContext> contexts = this.getBuildContexts(kind);
        boolean isBatch = this.isBatch(kind);
        for (BuildParticipant buildParticipant : participants) {
            System.currentTimeMillis();
            try {
                buildParticipant.buildStarting(contexts, isBatch, monitor);
            }
            catch (Exception e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
            }
        }
        while (!contexts.isEmpty()) {
            BuildContext context = contexts.remove(0);
            for (BuildParticipant buildParticipant : participants) {
                try {
                    buildParticipant.build(context, monitor);
                }
                catch (Exception e) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
                }
            }
            this.cleanProblemMarkers(context);
            List<IProblem> problems = context.getRecordedProblems();
            if (problems.isEmpty()) continue;
            for (IProblem problem : problems) {
                this.addMarker(context, problem);
            }
        }
        for (BuildParticipant buildParticipant : participants) {
            System.currentTimeMillis();
            try {
                buildParticipant.buildFinishing(monitor);
            }
            catch (Exception e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
            }
        }
        return new IProject[0];
    }

    private void cleanProblemMarkers(BuildContext context) throws CoreException {
        if (context != null && context.getFile() != null) {
            context.getFile().deleteMarkers("com.aptana.ide.core.ui.problem", false, 1);
        }
    }

    private void addMarker(BuildContext context, IProblem problem) throws CoreException {
        IMarker marker = context.getFile().createMarker("com.aptana.ide.core.ui.problem");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("charStart", problem.startOffset());
        attributes.put("charEnd", problem.endOffset());
        attributes.put("message", problem.getMessage());
        attributes.put("severity", problem.getSeverity());
        if (problem.lineNumber() > 0) {
            attributes.put("lineNumber", problem.lineNumber());
        }
        attributes.put("id", problem.getId());
        marker.setAttributes(attributes);
    }

    private List<BuildContext> getBuildContexts(int kind) {
        if (this.isBatch(kind)) {
            return this.getFullProjectContexts();
        }
        return this.getIncrementalContexts();
    }

    private List<BuildContext> getFullProjectContexts() {
        final ArrayList<BuildContext> contexts = new ArrayList<BuildContext>();
        try {
            this.getProject().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1) {
                        contexts.add(new BuildContext((IFile)proxy.requestResource()));
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
        }
        return contexts;
    }

    private List<BuildContext> getIncrementalContexts() {
        final ArrayList<BuildContext> contexts = new ArrayList<BuildContext>();
        try {
            this.getDelta(this.getProject()).accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && (delta.getKind() == 1 || delta.getKind() == 4)) {
                        contexts.add(new BuildContext((IFile)resource));
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
        }
        return contexts;
    }

    private boolean isBatch(int kind) {
        return kind == 6 || kind == 15;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (this.getProject() == null || !this.getProject().isAccessible()) {
            return;
        }
        List<BuildParticipant> participants = this.getBuildParticipants();
        for (BuildParticipant buildParticipant : participants) {
            buildParticipant.cleanStarting(this.getProject());
        }
        super.clean(monitor);
    }

    private List<BuildParticipant> getBuildParticipants() {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.aptana.ide.core", BUILD_PARTICIPANT_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return Collections.emptyList();
        }
        final HashMap<BuildParticipant, Integer> participants = new HashMap<BuildParticipant, Integer>();
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                block8: {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    try {
                        BuildParticipant participant = (BuildParticipant)configElement.createExecutableExtension("class");
                        if (!participant.isActive(this.getProject())) break block8;
                        String rawPriority = configElement.getAttribute("priority");
                        Integer priority = DEFAULT_PRIORITY;
                        try {
                            if (rawPriority != null) {
                                priority = Integer.parseInt(rawPriority);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            priority = DEFAULT_PRIORITY;
                        }
                        participants.put(participant, priority);
                    }
                    catch (CoreException e) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), e.getMessage(), e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList<BuildParticipant> sorted = new ArrayList<BuildParticipant>(participants.keySet());
        Collections.sort(sorted, new Comparator<BuildParticipant>(){

            @Override
            public int compare(BuildParticipant o1, BuildParticipant o2) {
                return ((Integer)participants.get(o2)).compareTo((Integer)participants.get(o1));
            }
        });
        return sorted;
    }
}

