/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.builder;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StreamUtils;
import com.aptana.ide.core.builder.IProblem;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.eclipse.ParsingRegistry;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildContext {
    private IFile fFile;
    private IParseState fParseState;
    private List<IProblem> problems;

    public BuildContext(IFile file) {
        this.fFile = file;
        this.problems = new ArrayList<IProblem>();
    }

    public IFile getFile() {
        return this.fFile;
    }

    public String getContents() {
        try {
            return StreamUtils.readContent(this.fFile.getContents(), this.fFile.getCharset());
        }
        catch (IOException e) {
            IdeLog.log(AptanaCorePlugin.getDefault(), 4, e.getMessage(), e);
        }
        catch (CoreException e) {
            IdeLog.log(AptanaCorePlugin.getDefault(), 4, e.getMessage(), e);
        }
        return null;
    }

    public LexemeList getLexemeList() {
        IParseState parseState = this.getParseState();
        if (parseState == null) {
            return null;
        }
        return parseState.getLexemeList();
    }

    public IParseNode getRootNode() {
        IParseState parseState = this.getParseState();
        if (parseState == null) {
            return null;
        }
        return parseState.getParseResults();
    }

    public IParseState getParseState() {
        if (this.fParseState != null) {
            return this.fParseState;
        }
        String language = this.getLanguage();
        if (language == null) {
            return null;
        }
        IParser parser = ParsingRegistry.getParser((String)language);
        if (parser == null) {
            parser = ParsingRegistry.createParser((String)language);
        }
        if (parser == null) {
            return null;
        }
        IParseState parseState = parser.createParseState(null);
        String contents = this.getContents();
        if (contents == null) {
            return null;
        }
        parseState.setEditState(contents, contents, 0, 0);
        try {
            parser.parse(parseState);
        }
        catch (ParseException e) {
            IdeLog.log(AptanaCorePlugin.getDefault(), 4, e.getMessage(), e);
        }
        catch (LexerException e) {
            IdeLog.log(AptanaCorePlugin.getDefault(), 4, e.getMessage(), e);
        }
        this.fParseState = parseState;
        return parseState;
    }

    private String getLanguage() {
        if (this.fFile == null || this.fFile.getFileExtension() == null) {
            return null;
        }
        String fileExtension = this.fFile.getFileExtension().toLowerCase();
        if (fileExtension.equals("htm") || fileExtension.equals("html") || fileExtension.equals("shtml") || fileExtension.equals("xhtml")) {
            return "text/html";
        }
        if (fileExtension.equals("css")) {
            return "text/css";
        }
        if (fileExtension.equals("js")) {
            return "text/javascript";
        }
        if (this.fFile.getName().endsWith(".html.erb")) {
            return "text/html+rb";
        }
        return null;
    }

    public void recordNewProblems(List<IProblem> problems) {
        this.problems.addAll(problems);
    }

    List<IProblem> getRecordedProblems() {
        return this.problems;
    }
}

