/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

public class SetExecutableBits
extends Job {
    private Bundle bundle;

    public SetExecutableBits(Bundle bundle) {
        super(Messages.SetExecutableBits_Set_Binary_As_Executable);
        this.bundle = bundle;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (Platform.getOS().equals("win32")) {
            return Status.OK_STATUS;
        }
        try {
            Properties props = new Properties();
            InputStream inStream = FileLocator.openStream((Bundle)this.bundle, (IPath)new Path("permissions.properties"), (boolean)false);
            props.load(inStream);
            String raw = props.getProperty("permissions.executable");
            String[] paths = raw.split(",");
            int i = 0;
            while (i < paths.length) {
                URL bundleURL = FileLocator.find((Bundle)this.bundle, (IPath)new Path(paths[i]), null);
                if (bundleURL == null) {
                    String message = MessageFormat.format(Messages.SetExecutableBits_File_Not_In_Bundle, paths[i], this.bundle.getSymbolicName());
                    IdeLog.logImportant(AptanaCorePlugin.getDefault(), message);
                } else {
                    URL fileURL = FileLocator.toFileURL((URL)bundleURL);
                    if (fileURL != null) {
                        String fullPath = fileURL.getPath();
                        this.setExecutableBit(fullPath);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            return new Status(4, "com.aptana.ide.core", 1, e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void setExecutableBit(String filePath) {
        if (filePath == null) {
            return;
        }
        try {
            Process pr = Runtime.getRuntime().exec(new String[]{"chmod", "a+x", filePath});
            StreamConsumer chmodOutput = new StreamConsumer(pr.getInputStream());
            chmodOutput.setName("chmod output reader");
            chmodOutput.start();
            StreamConsumer chmodError = new StreamConsumer(pr.getErrorStream());
            chmodError.setName("chmod error reader");
            chmodError.start();
        }
        catch (IOException ioe) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), ioe.getMessage(), ioe);
        }
    }

    public static class StreamConsumer
    extends Thread {
        InputStream is;
        byte[] buf;

        public StreamConsumer(InputStream inputStream) {
            this.setDaemon(true);
            this.is = inputStream;
            this.buf = new byte[512];
        }

        public void run() {
            try {
                int n = 0;
                while (n >= 0) {
                    n = this.is.read(this.buf);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

