/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.Messages;
import com.aptana.ide.core.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassLoader
extends ClassLoader {
    private List<Bundle> _bundles = new ArrayList<Bundle>();

    public BundleClassLoader() {
        super(BundleClassLoader.class.getClassLoader());
    }

    public void addBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(Messages.BundleClassLoader_BundleMustNotBeNull);
        }
        if (!this._bundles.contains(bundle)) {
            this._bundles.add(bundle);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = this.loadClassFromBundles(name);
        if (result == null) {
            throw new ClassNotFoundException(StringUtils.format(Messages.BundleClassLoader_UnableToFindClass, name));
        }
        return result;
    }

    @Override
    protected URL findResource(String name) {
        URL result = super.findResource(name);
        if (result == null) {
            for (Bundle bundle : this._bundles) {
                result = bundle.getResource(name);
                if (result != null) break;
            }
        }
        return result;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration result = super.findResources(name);
        if (result == null) {
            for (Bundle bundle : this._bundles) {
                result = bundle.getResources(name);
                if (result != null) break;
            }
        }
        if (result == null) {
            throw new IOException(StringUtils.format(Messages.BundleClassLoader_UnableToFindResources, name));
        }
        return result;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result = super.loadClass(name);
        if (result == null) {
            result = this.loadClassFromBundles(name);
        }
        if (result == null) {
            throw new ClassNotFoundException(StringUtils.format(Messages.BundleClassLoader_UnableToLoadClass, name));
        }
        return result;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = super.loadClass(name, resolve);
        if (result == null) {
            result = this.loadClassFromBundles(name);
        }
        if (result == null) {
            throw new ClassNotFoundException(StringUtils.format(Messages.BundleClassLoader_UnableToLoadClass, name));
        }
        return result;
    }

    private Class<?> loadClassFromBundles(String name) throws ClassNotFoundException {
        Class result = null;
        for (Bundle bundle : this._bundles) {
            result = bundle.loadClass(name);
            if (result != null) break;
        }
        return result;
    }
}

