/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.view;

import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.MarkerUtils;
import com.aptana.ide.logging.ILogResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;

public class LoggingMarkerRulerAction
extends ResourceAction
implements IUpdate {
    private static final int MAX_LABEL_LENGTH = 80;
    private final ResourceBundle bundle;
    private String label;
    private final String prefix;
    private final Shell shell;
    private final IVerticalRuler ruler;
    private final boolean askForLabel;
    private final String markerType;
    private final IDocument document;
    private final IAnnotationModel model;
    private final IUniformResource resource;
    private List markers;

    public LoggingMarkerRulerAction(ResourceBundle bundle, String prefix, ILogResource resource, IDocument document, IAnnotationModel annotationModel, IVerticalRuler ruler, boolean askForLabel, String markerType, Shell shell) {
        super(bundle, prefix);
        this.bundle = bundle;
        this.prefix = prefix;
        this.ruler = ruler;
        this.askForLabel = askForLabel;
        this.markerType = markerType;
        this.document = document;
        this.model = annotationModel;
        this.shell = shell;
        this.resource = resource;
        this.label = LoggingMarkerRulerAction.getString((ResourceBundle)bundle, (String)(String.valueOf(prefix) + ".label"), (String)(String.valueOf(prefix) + ".label"));
    }

    public void run() {
        this.update();
        if (this.markers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.markers);
        }
    }

    public void update() {
        int line = this.ruler.getLineOfLastMouseButtonActivity() + 1;
        if (line > this.document.getNumberOfLines()) {
            this.setEnabled(false);
            this.setText(this.label);
        } else {
            this.markers = this.getMarkers();
            this.setEnabled(this.resource != null);
            this.setText(this.label);
        }
    }

    protected void addMarker() {
        Map attributes = this.createAttributes();
        if (this.askForLabel && !this.askForLabel(attributes)) {
            return;
        }
        try {
            MarkerUtils.createMarkerForExternalResource((IUniformResource)this.resource, (Map)attributes, (String)this.markerType);
        }
        catch (CoreException x) {
            this.handleCoreException(x, "Unxepected exception");
        }
        this.ruler.update();
    }

    protected boolean askForLabel(Map attributes) {
        String proposal;
        Object o = attributes.get("message");
        String string = proposal = o instanceof String ? (String)o : "";
        if (proposal == null) {
            proposal = "";
        }
        String title = LoggingMarkerRulerAction.getString((ResourceBundle)this.bundle, (String)(String.valueOf(this.prefix) + "add.dialog.title"), (String)(String.valueOf(this.prefix) + "add.dialog.title"));
        String message = LoggingMarkerRulerAction.getString((ResourceBundle)this.bundle, (String)(String.valueOf(this.prefix) + "add.dialog.message"), (String)(String.valueOf(this.prefix) + "add.dialog.message"));
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                return newText == null || newText.trim().length() == 0 ? " " : null;
            }
        };
        InputDialog dialog = new InputDialog(this.shell, title, message, proposal, inputValidator);
        String label = null;
        if (dialog.open() != 1) {
            label = dialog.getValue();
        }
        if (label == null) {
            return false;
        }
        if ((label = label.trim()).length() == 0) {
            return false;
        }
        MarkerUtils.setMessage((Map)attributes, (String)label);
        return true;
    }

    protected void removeMarkers(List markers) {
        try {
            int i = 0;
            while (i < markers.size()) {
                IMarker marker = (IMarker)markers.get(i);
                marker.delete();
                ++i;
            }
        }
        catch (CoreException x) {
            this.handleCoreException(x, "Unexpected exception");
        }
    }

    private Map createAttributes() {
        HashMap attributes = new HashMap();
        int line = this.ruler.getLineOfLastMouseButtonActivity();
        int start = -1;
        int end = -1;
        int length = 0;
        try {
            IRegion lineInformation = this.document.getLineInformation(line);
            start = lineInformation.getOffset();
            length = lineInformation.getLength();
            end = start + length;
        }
        catch (BadLocationException badLocationException) {}
        MarkerUtils.setMessage(attributes, (String)this.getLabelProposal(this.document, start, length));
        MarkerUtils.setLineNumber(attributes, (int)(line + 1));
        MarkerUtils.setCharStart(attributes, (int)start);
        MarkerUtils.setCharEnd(attributes, (int)end);
        return attributes;
    }

    protected String getLabelProposal(IDocument document, int offset, int length) {
        try {
            String label = document.get(offset, length).trim();
            if (label.length() <= 80) {
                return label;
            }
            return label.substring(0, 80);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected void handleCoreException(CoreException exception, String message) {
        String title = LoggingMarkerRulerAction.getString((ResourceBundle)this.bundle, (String)(String.valueOf(this.prefix) + "error.dialog.title"), (String)(String.valueOf(this.prefix) + "error.dialog.title"));
        String msg = LoggingMarkerRulerAction.getString((ResourceBundle)this.bundle, (String)(String.valueOf(this.prefix) + "error.dialog.message"), (String)(String.valueOf(this.prefix) + "error.dialog.message"));
        ErrorDialog.openError((Shell)this.shell, (String)title, (String)msg, (IStatus)exception.getStatus());
    }

    protected List getMarkers() {
        IMarker[] allMarkers;
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        if (this.resource != null && this.model != null && (allMarkers = MarkerUtils.findMarkers((IUniformResource)this.resource, (String)this.markerType, (boolean)true)) != null) {
            int i = 0;
            while (i < allMarkers.length) {
                if (this.includesRulerLine(((AbstractMarkerAnnotationModel)this.model).getMarkerPosition(allMarkers[i]), this.document)) {
                    markers.add(allMarkers[i]);
                }
                ++i;
            }
        }
        return markers;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.ruler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }
}

