/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.preferences;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.ColorCellEditor;
import com.aptana.ide.editors.preferences.ColorizationScrolledComposite;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.IErrorHandler;
import com.aptana.ide.editors.unified.colorizer.LanguageStructureProvider;
import com.aptana.ide.editors.unified.colorizer.Region;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.preferences.LoggingStructureProvider;
import com.aptana.ide.logging.preferences.Messages;
import com.aptana.ide.logging.preferences.NewRuleDialog;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LoggingPreferenceWidget {
    private ColorizationScrolledComposite scrolls;
    private ExpandableComposite tokenExpandable;
    private ExpandableComposite editorExpandable;
    private Label description;
    private Composite displayArea;
    private TreeViewer viewer;
    private Tree tree;
    private RGB black;
    private LoggingStructureProvider provider;
    private Button importButton;
    private Button exportButton;
    private Button override;
    private ColorSelector backgroundSelector;
    private ColorSelector lineHighlightSelector;
    private ColorSelector selectionForegroundSelector;
    private ColorSelector selectionBackgroundSelector;
    private ColorSelector foldingBackgroundSelector;
    private ColorSelector foldingForegroundSelector;
    private ColorSelector caretSelector;
    private Composite coloringComposite;
    private IErrorHandler errorHandler;
    private static final Object INPUT = new Object();
    private static final String[] COLUMNS = new String[]{"!", "Token", "R", "FG", "B", "I", "U"};
    private static final String[] REGION_COLUMNS = new String[]{"Name", "Offset", "Length", "FG", "B", "I", "U"};
    private static final String[] REGION_TABLE_COLUMNS = new String[]{"Name", "Offset", "Length", "", "", "", ""};
    private static final int ICON_COLUMN_WIDTH = 17;
    protected static final int MIN_READ_TIMEOUT = 50;
    private IStructuredContentProvider regionContentProvider = new IStructuredContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return map.values().toArray();
            }
            return null;
        }
    };
    private ITableLabelProvider nullLabelProvider = new ITableLabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    };
    private ITreeContentProvider nullContentProvider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }
    };
    private ITableLabelProvider regionLabelProvider = new ITableLabelProvider(){
        private Map imageMap = new HashMap();

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            Iterator iter = this.imageMap.values().iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            Region region = (Region)element;
            if (columnIndex == 0) {
                return region.getName();
            }
            if (columnIndex == 1) {
                return region.getOffsetString();
            }
            if (columnIndex == 2) {
                return region.getLengthString();
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Region region = (Region)element;
            ColorizationStyle style = region.getStyle();
            if (columnIndex == 3 && style != null) {
                Color fg = style.getForegroundColor();
                Image img = null;
                if (!this.imageMap.containsKey(fg.getRGB())) {
                    img = new Image((Device)Display.getCurrent(), 16, 16);
                    GC gc = new GC((Drawable)img);
                    gc.setBackground(fg);
                    gc.fillRectangle(1, 1, 13, 13);
                    gc.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
                    gc.drawRectangle(1, 1, 13, 13);
                    gc.dispose();
                    this.imageMap.put(fg.getRGB(), img);
                } else {
                    img = (Image)this.imageMap.get(fg.getRGB());
                }
                return img;
            }
            if (columnIndex == 4) {
                if (style != null && style.isBold()) {
                    return UnifiedEditorsPlugin.getImage((String)"icons/bold_on.gif");
                }
                return UnifiedEditorsPlugin.getImage((String)"icons/bold_off.gif");
            }
            if (columnIndex == 5) {
                if (style != null && style.isItalic()) {
                    return UnifiedEditorsPlugin.getImage((String)"icons/italic_on.gif");
                }
                return UnifiedEditorsPlugin.getImage((String)"icons/italic_off.gif");
            }
            if (columnIndex == 6) {
                if (style != null && style.isUnderline()) {
                    return UnifiedEditorsPlugin.getImage((String)"icons/underline_on.gif");
                }
                return UnifiedEditorsPlugin.getImage((String)"icons/underline_off.gif");
            }
            return null;
        }
    };
    private ICellModifier regionModifier = new ICellModifier(){

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            ColorizationStyle style = null;
            if (element instanceof Region) {
                style = ((Region)element).getStyle();
            }
            if (style != null) {
                if (value instanceof Boolean) {
                    Boolean bool = (Boolean)value;
                    if (property == REGION_COLUMNS[4]) {
                        style.setBold(bool.booleanValue());
                    } else if (property == REGION_COLUMNS[5]) {
                        style.setItalic(bool.booleanValue());
                    } else if (property == REGION_COLUMNS[6]) {
                        style.setUnderline(bool.booleanValue());
                    }
                } else if (value instanceof RGB) {
                    RGB rgb = (RGB)value;
                    if (property == REGION_COLUMNS[3]) {
                        style.setForegroundColor(UnifiedColorManager.getInstance().getColor(rgb));
                    }
                } else if (value instanceof String) {
                    String text = (String)value;
                    Region region = (Region)element;
                    if (property == REGION_COLUMNS[0]) {
                        IToken token = (IToken)LoggingPreferenceWidget.this.viewer.getTree().getSelection()[0].getData();
                        LoggingPreferenceWidget.this.provider.removeRegion(token, region.getName());
                        region.setName(text);
                        LoggingPreferenceWidget.this.provider.addRegion(token, region);
                    } else if (property == REGION_COLUMNS[1]) {
                        boolean offsetRelative = false;
                        try {
                            int offsetInt;
                            if (text.startsWith("LENGTH")) {
                                offsetInt = Integer.parseInt(text.substring("LENGTH".length(), text.length()));
                                offsetRelative = true;
                            } else {
                                offsetInt = Integer.parseInt(text);
                            }
                            region.setOffset(offsetInt);
                            region.setRelativeOffset(offsetRelative);
                            region.setOffsetString(text);
                        }
                        catch (Exception exception) {}
                    } else if (property == REGION_COLUMNS[2]) {
                        boolean lengthRelative = false;
                        try {
                            int lengthInt;
                            if (text.startsWith("LENGTH")) {
                                lengthInt = Integer.parseInt(text.substring("LENGTH".length(), text.length()));
                                lengthRelative = true;
                            } else {
                                lengthInt = Integer.parseInt(text);
                            }
                            region.setLength(lengthInt);
                            region.setRelativeLength(lengthRelative);
                            region.setLengthString(text);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }

        public Object getValue(Object element, String property) {
            ColorizationStyle style = null;
            if (element instanceof Region) {
                style = ((Region)element).getStyle();
            }
            if (style != null) {
                if (property == REGION_COLUMNS[0]) {
                    return ((Region)element).getName();
                }
                if (property == REGION_COLUMNS[1]) {
                    return ((Region)element).getOffsetString();
                }
                if (property == REGION_COLUMNS[2]) {
                    return ((Region)element).getLengthString();
                }
                if (property == REGION_COLUMNS[3]) {
                    return style.getForegroundColor().getRGB();
                }
                if (property == REGION_COLUMNS[4]) {
                    return style.isBold();
                }
                if (property == REGION_COLUMNS[5]) {
                    return style.isItalic();
                }
                if (property == REGION_COLUMNS[6]) {
                    return style.isUnderline();
                }
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }
    };
    private Button addStringRuleButton;
    private Button removeRuleButton;
    private Button editRuleButton;
    private Button addRegexpRuleButton;
    private Composite autoboldingComposite;
    private Button autoboldingBox;
    private Button upRuleButton;
    private Button downRuleButton;
    private Button wrappingBox;
    private Combo charsetCombo;
    private Text bufferText;
    private Text timeoutText;
    private Text backlogText;
    private TabFolder folder;
    private ColorSelector cursorLineColorSelector;
    private Label fontStyleLabel;
    private ColorSelector textForegroundColorSelector;

    public void dispose() {
        if (this.provider != null) {
            this.provider.disposeImages();
        }
        this.regionLabelProvider.dispose();
    }

    public void createControl(Composite parent, GridData mainCompositeData) {
        this.black = new RGB(0, 0, 0);
        Label l = new Label(parent, 0);
        l.setText(Messages.LoggingPreferenceWidget_CUSTOMIZE_LABEL);
        this.folder = new TabFolder(parent, 0);
        this.folder.setData((Object)mainCompositeData);
        this.createGeneralTab(this.folder);
        this.createColoringTab(this.folder);
    }

    public void activateTab(int tab) {
        this.folder.setSelection(tab);
    }

    private void createGeneralTab(TabFolder folder) {
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(Messages.General_Tab_Name);
        generalTab.setToolTipText(Messages.General_Tab_ToolTip);
        Composite generalComposite = new Composite((Composite)folder, 0);
        generalComposite.setFont(folder.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 10;
        generalComposite.setLayout((Layout)layout);
        generalTab.setControl((Control)generalComposite);
        this.createAppearance(generalComposite);
        this.createTail(generalComposite);
        this.createAutobolding(generalComposite);
        generalComposite.setFocus();
        this.createWrapping(generalComposite);
    }

    private void createColoringTab(TabFolder folder) {
        TabItem coloringTab = new TabItem(folder, 0);
        coloringTab.setText(Messages.Coloring_Tab_Name);
        coloringTab.setToolTipText(Messages.Coloring_Tab_ToolTip);
        Color systemWidgetBGColor = this.getControl().getDisplay().getSystemColor(22);
        this.coloringComposite = new Composite((Composite)folder, 0);
        this.coloringComposite.setFont(folder.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 10;
        this.coloringComposite.setLayout((Layout)layout);
        this.coloringComposite.setBackground(systemWidgetBGColor);
        coloringTab.setControl((Control)this.coloringComposite);
        this.createIntroduction(this.coloringComposite);
        this.scrolls = new ColorizationScrolledComposite(this.coloringComposite);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        this.scrolls.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.scrolls.setLayoutData((Object)gridData);
        this.displayArea = this.scrolls.getBody();
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        this.displayArea.setLayout((Layout)layout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.styleImportExport();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.tokenExpandable = new ExpandableComposite(this.displayArea, 0, 18);
        this.tokenExpandable.setText(Messages.LoggingColorizationWidget_29);
        this.tokenExpandable.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tokenExpandable.setLayout((Layout)gridLayout);
        this.tokenExpandable.setExpanded(UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.EXPAND_TOKENS"));
        this.tokenExpandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                LoggingPreferenceWidget.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.makeScrollableCompositeAware((Control)this.tokenExpandable);
        Composite inner = new Composite((Composite)this.tokenExpandable, 0);
        gridLayout = new GridLayout(2, false);
        inner.setLayout((Layout)gridLayout);
        this.tokenExpandable.setClient((Control)inner);
        this.createAddRuleButtons(inner);
        this.tree = new Tree(inner, 68100);
        this.tree.setHeaderVisible(false);
        this.tree.setLinesVisible(false);
        GridData treeLayoutData = new GridData(4, 4, true, true);
        treeLayoutData.heightHint = this.tree.getItemHeight() * 16;
        treeLayoutData.widthHint = 300;
        this.tree.setLayoutData((Object)treeLayoutData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.tree.setLayout((Layout)gridLayout);
        this.viewer = new TreeViewer(this.tree);
        this.viewer.setAutoExpandLevel(2);
        this.styleCells();
        this.createRuleButtons(inner);
    }

    private void createIntroduction(Composite parent) {
        this.description = new Label(parent, 16448);
        GridData dData = new GridData(4, 4, false, false);
        dData.widthHint = 400;
        this.description.setLayoutData((Object)dData);
        this.description.setText(Messages.LoggingPreferenceWidget_0);
    }

    private void createAutobolding(Composite parent) {
        this.autoboldingComposite = new Composite(parent, 0);
        this.autoboldingComposite.setLayout((Layout)new GridLayout(2, false));
        this.autoboldingComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.autoboldingBox = new Button(this.autoboldingComposite, 32);
        this.autoboldingBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (LoggingPreferenceWidget.this.provider != null) {
                    LoggingPreferenceWidget.this.provider.setAutoBolding(LoggingPreferenceWidget.this.autoboldingBox.getSelection());
                }
            }
        });
        Label label = new Label(this.autoboldingComposite, 0);
        label.setText(Messages.LoggingPreferenceWidget_Autobolding_Label);
    }

    private void createAppearance(Composite parent) {
        final Group appearanceGroup = new Group(parent, 0);
        appearanceGroup.setLayout((Layout)new GridLayout(3, false));
        appearanceGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        appearanceGroup.setText(Messages.LoggingPreferenceWidget_1);
        Label label = new Label((Composite)appearanceGroup, 0);
        label.setText(Messages.LoggingPreferenceWidget_CursorLineColor_Label);
        this.cursorLineColorSelector = new ColorSelector((Composite)appearanceGroup);
        this.cursorLineColorSelector.getButton().setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        this.cursorLineColorSelector.setEnabled(true);
        this.cursorLineColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                RGB newRGB = (RGB)event.getNewValue();
                if (!newRGB.equals(event.getOldValue())) {
                    LoggingPreferenceWidget.this.provider.setCursorLineColor(newRGB);
                }
                LoggingPreferenceWidget.this.cursorLineColorSelector.setColorValue(newRGB);
            }
        });
        label = new Label((Composite)appearanceGroup, 0);
        label.setText(Messages.LoggingPreferenceWidget_TextForegroundColor_Label);
        this.textForegroundColorSelector = new ColorSelector((Composite)appearanceGroup);
        this.textForegroundColorSelector.getButton().setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        this.textForegroundColorSelector.setEnabled(true);
        this.textForegroundColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                RGB newRGB = (RGB)event.getNewValue();
                if (!newRGB.equals(event.getOldValue())) {
                    LoggingPreferenceWidget.this.provider.setTextForegroundColor(newRGB);
                }
                LoggingPreferenceWidget.this.textForegroundColorSelector.setColorValue(newRGB);
            }
        });
        label = new Label((Composite)appearanceGroup, 0x1004000);
        label.setText(Messages.LoggingPreferenceWidget_Font_Label);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        this.fontStyleLabel = new Label((Composite)appearanceGroup, 0x1004000);
        this.fontStyleLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        final Button fontButton = new Button((Composite)appearanceGroup, 0);
        fontButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (LoggingPreferenceWidget.this.provider != null) {
                    FontDialog dialog = new FontDialog(fontButton.getShell());
                    dialog.setFontList(LoggingPreferenceWidget.this.getPreferences().getFontData());
                    if (dialog.open() != null) {
                        FontData[] font = dialog.getFontList();
                        LoggingPreferenceWidget.this.provider.setFont(font);
                        if (font != null && font.length > 0) {
                            String fontStr = String.valueOf(font[0].getName()) + "-" + font[0].getHeight();
                            LoggingPreferenceWidget.this.fontStyleLabel.setText(fontStr);
                            appearanceGroup.layout(true, true);
                        }
                    }
                }
            }
        });
        fontButton.setLayoutData((Object)new GridData(2, 2, false, false));
        fontButton.setText(Messages.LoggingPreferenceWidget_4);
        Label charsetLabel = new Label((Composite)appearanceGroup, 0x1004000);
        charsetLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        charsetLabel.setText(Messages.LoggingPreferenceWidget_5);
        this.charsetCombo = new Combo((Composite)appearanceGroup, 16793608);
        this.charsetCombo.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        Set<String> charsets = Charset.availableCharsets().keySet();
        String[] items = new String[charsets.size()];
        charsets.toArray(items);
        this.charsetCombo.setItems(items);
        this.charsetCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (LoggingPreferenceWidget.this.provider != null) {
                    String selected = LoggingPreferenceWidget.this.charsetCombo.getItem(LoggingPreferenceWidget.this.charsetCombo.getSelectionIndex());
                    LoggingPreferenceWidget.this.provider.setDefaultEncoding(selected);
                }
            }
        });
    }

    private void createTail(Composite parent) {
        Group tailGroup = new Group(parent, 0);
        tailGroup.setLayout((Layout)new GridLayout(2, false));
        tailGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        tailGroup.setText(Messages.LoggingPreferenceWidget_6);
        Label label = new Label((Composite)tailGroup, 16384);
        label.setText(Messages.LoggingPreferenceWidget_7);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        this.timeoutText = new Text((Composite)tailGroup, 18432);
        this.timeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String contentText = LoggingPreferenceWidget.this.timeoutText.getText();
                try {
                    int val = Integer.parseInt(contentText);
                    if (val < 50 && LoggingPreferenceWidget.this.errorHandler != null) {
                        LoggingPreferenceWidget.this.errorHandler.setErrorMessage(String.valueOf(Messages.LoggingPreferenceWidget_8) + 50);
                    }
                    if (LoggingPreferenceWidget.this.errorHandler != null) {
                        LoggingPreferenceWidget.this.errorHandler.setErrorMessage(null);
                    }
                    LoggingPreferenceWidget.this.provider.setReadTimeout(val);
                }
                catch (NumberFormatException numberFormatException) {
                    LoggingPreferenceWidget.this.errorHandler.setErrorMessage(Messages.LoggingPreferenceWidget_9);
                    return;
                }
            }
        });
        this.timeoutText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)tailGroup, 16384);
        label.setText(Messages.LoggingPreferenceWidget_10);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        this.bufferText = new Text((Composite)tailGroup, 18432);
        this.bufferText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String contentText = LoggingPreferenceWidget.this.bufferText.getText();
                try {
                    int val = Integer.parseInt(contentText);
                    if (val <= 0 && LoggingPreferenceWidget.this.errorHandler != null) {
                        LoggingPreferenceWidget.this.errorHandler.setErrorMessage(Messages.LoggingPreferenceWidget_11);
                    }
                    if (LoggingPreferenceWidget.this.errorHandler != null) {
                        LoggingPreferenceWidget.this.errorHandler.setErrorMessage(null);
                    }
                    LoggingPreferenceWidget.this.provider.setReadBuffer(val);
                }
                catch (NumberFormatException numberFormatException) {
                    LoggingPreferenceWidget.this.errorHandler.setErrorMessage(Messages.LoggingPreferenceWidget_12);
                    return;
                }
            }
        });
        this.bufferText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)tailGroup, 16384);
        label.setText(Messages.LoggingPreferenceWidget_13);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        this.backlogText = new Text((Composite)tailGroup, 18432);
        this.backlogText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String contentText = LoggingPreferenceWidget.this.backlogText.getText();
                try {
                    int val = Integer.parseInt(contentText);
                    if (val <= 0 && LoggingPreferenceWidget.this.errorHandler != null) {
                        LoggingPreferenceWidget.this.errorHandler.setErrorMessage(Messages.LoggingPreferenceWidget_14);
                    }
                    if (LoggingPreferenceWidget.this.errorHandler != null) {
                        LoggingPreferenceWidget.this.errorHandler.setErrorMessage(null);
                    }
                    LoggingPreferenceWidget.this.provider.setBacklogLines(val);
                }
                catch (NumberFormatException numberFormatException) {
                    LoggingPreferenceWidget.this.errorHandler.setErrorMessage(Messages.LoggingPreferenceWidget_15);
                    return;
                }
            }
        });
        this.backlogText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createWrapping(Composite parent) {
        Composite wrappingComposite = new Composite(parent, 0);
        wrappingComposite.setLayout((Layout)new GridLayout(2, false));
        wrappingComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.wrappingBox = new Button(wrappingComposite, 32);
        this.wrappingBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (LoggingPreferenceWidget.this.provider != null) {
                    LoggingPreferenceWidget.this.provider.setWrapping(LoggingPreferenceWidget.this.wrappingBox.getSelection());
                }
            }
        });
        Label label = new Label(wrappingComposite, 0);
        label.setText(Messages.LoggingPreferenceWidget_Wrapping_Label);
    }

    private void createAddRuleButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.addStringRuleButton = new Button(buttonsComposite, 0);
        this.addStringRuleButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addStringRuleButton.setToolTipText(Messages.LoggingColorizationWidget_30);
        this.addStringRuleButton.setImage(SWTUtils.getImage((AbstractUIPlugin)CoreUIPlugin.getDefault(), (String)"/icons/add.gif"));
        this.addStringRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferenceWidget.this.addRule();
            }
        });
        this.editRuleButton = new Button(buttonsComposite, 0);
        this.editRuleButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.editRuleButton.setToolTipText(Messages.LoggingColorizationWidget_32);
        this.editRuleButton.setImage(SWTUtils.getImage((AbstractUIPlugin)CoreUIPlugin.getDefault(), (String)"/icons/edit.png"));
        this.editRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferenceWidget.this.editRule();
            }
        });
        this.removeRuleButton = new Button(buttonsComposite, 0);
        this.removeRuleButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeRuleButton.setToolTipText(Messages.LoggingColorizationWidget_31);
        this.removeRuleButton.setImage(SWTUtils.getImage((AbstractUIPlugin)CoreUIPlugin.getDefault(), (String)"/icons/delete.gif"));
        this.removeRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferenceWidget.this.removeRule();
            }
        });
    }

    private void createRuleButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.upRuleButton = new Button(buttonsComposite, 0);
        this.upRuleButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.upRuleButton.setToolTipText(Messages.LoggingColorizationWidget_UpRuleButton);
        this.upRuleButton.setImage(SWTUtils.getImage((AbstractUIPlugin)LoggingPlugin.getDefault(), (String)"/icons/upward_nav_on.gif"));
        this.upRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferenceWidget.this.moveRuleUp();
            }
        });
        this.downRuleButton = new Button(buttonsComposite, 0);
        this.downRuleButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.downRuleButton.setToolTipText(Messages.LoggingColorizationWidget_DownRuleButton);
        this.downRuleButton.setImage(SWTUtils.getImage((AbstractUIPlugin)LoggingPlugin.getDefault(), (String)"/icons/downward_nav_on.gif"));
        this.downRuleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LoggingPreferenceWidget.this.moveRuleDown();
            }
        });
    }

    public Control getControl() {
        return this.folder;
    }

    private void loadEditorOptions() {
    }

    private void makeScrollableCompositeAware(Control control) {
        ColorizationScrolledComposite parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    private void expandedStateChanged(ExpandableComposite expandable) {
        ColorizationScrolledComposite parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    private ColorizationScrolledComposite getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ColorizationScrolledComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ColorizationScrolledComposite) {
            return (ColorizationScrolledComposite)parent;
        }
        return null;
    }

    private void styleEditorOptions() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.editorExpandable = new ExpandableComposite(this.displayArea, 0, 18);
        this.editorExpandable.setText(Messages.LoggingColorizationWidget_33);
        this.editorExpandable.setLayoutData((Object)new GridData(4, 4, true, false));
        this.editorExpandable.setLayout((Layout)gridLayout);
        this.editorExpandable.setExpanded(UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.EXPAND_EDITOR_OPTIONS"));
        this.editorExpandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                LoggingPreferenceWidget.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.makeScrollableCompositeAware((Control)this.editorExpandable);
        Composite inner = new Composite((Composite)this.editorExpandable, 0);
        inner.setLayout((Layout)gridLayout);
        this.editorExpandable.setClient((Control)inner);
        this.override = new Button(inner, 32);
        this.override.setEnabled(false);
        this.override.setText(Messages.LoggingColorizationWidget_34);
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = LoggingPreferenceWidget.this.override.getSelection();
                if (isSelected) {
                    Color blackColor = UnifiedColorManager.getInstance().getColor(LoggingPreferenceWidget.this.black);
                    Color grayColor = UnifiedColorManager.getInstance().getColor(new RGB(139, 139, 139));
                    IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
                    RGB background = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
                    RGB lineHighlight = PreferenceConverter.getColor((IPreferenceStore)store, (String)"currentLineColor");
                    RGB selectionFg = LoggingPreferenceWidget.this.getControl().getDisplay().getSystemColor(27).getRGB();
                    RGB selectionBg = LoggingPreferenceWidget.this.getControl().getDisplay().getSystemColor(26).getRGB();
                    Color eclipseBackgroundColor = UnifiedColorManager.getInstance().getColor(background);
                    Color eclipseLineHighlightColor = UnifiedColorManager.getInstance().getColor(lineHighlight);
                    Color eclipseSelectionFgColor = UnifiedColorManager.getInstance().getColor(selectionFg);
                    Color eclipseSelectionBgColor = UnifiedColorManager.getInstance().getColor(selectionBg);
                    Color systemWidgetBGColor = LoggingPreferenceWidget.this.getControl().getDisplay().getSystemColor(22);
                    LoggingPreferenceWidget.this.provider.setBackgroundColor(eclipseBackgroundColor);
                    LoggingPreferenceWidget.this.provider.setCaretColor(blackColor);
                    LoggingPreferenceWidget.this.provider.setLineHighlightColor(eclipseLineHighlightColor);
                    LoggingPreferenceWidget.this.provider.setSelectionForegroundColor(eclipseSelectionFgColor);
                    LoggingPreferenceWidget.this.provider.setSelectionBackgroundColor(eclipseSelectionBgColor);
                    LoggingPreferenceWidget.this.provider.setFoldingBackgroundColor(systemWidgetBGColor);
                    LoggingPreferenceWidget.this.provider.setFoldingForegroundColor(grayColor);
                    LoggingPreferenceWidget.this.backgroundSelector.setColorValue(LoggingPreferenceWidget.this.provider.getBackgroundColor().getRGB());
                    LoggingPreferenceWidget.this.lineHighlightSelector.setColorValue(LoggingPreferenceWidget.this.provider.getLineHighlightColor().getRGB());
                    LoggingPreferenceWidget.this.selectionForegroundSelector.setColorValue(LoggingPreferenceWidget.this.provider.getSelectionForegroundColor().getRGB());
                    LoggingPreferenceWidget.this.selectionBackgroundSelector.setColorValue(LoggingPreferenceWidget.this.provider.getSelectionBackgroundColor().getRGB());
                    LoggingPreferenceWidget.this.foldingBackgroundSelector.setColorValue(LoggingPreferenceWidget.this.provider.getFoldingBackgroundColor().getRGB());
                    LoggingPreferenceWidget.this.foldingForegroundSelector.setColorValue(LoggingPreferenceWidget.this.provider.getFoldingForegroundColor().getRGB());
                    LoggingPreferenceWidget.this.caretSelector.setColorValue(LoggingPreferenceWidget.this.provider.getCaretColor().getRGB());
                } else {
                    LoggingPreferenceWidget.this.provider.setBackgroundColor(null);
                    LoggingPreferenceWidget.this.provider.setCaretColor(null);
                    LoggingPreferenceWidget.this.provider.setLineHighlightColor(null);
                    LoggingPreferenceWidget.this.provider.setSelectionForegroundColor(null);
                    LoggingPreferenceWidget.this.provider.setSelectionBackgroundColor(null);
                    LoggingPreferenceWidget.this.provider.setFoldingBackgroundColor(null);
                    LoggingPreferenceWidget.this.provider.setFoldingForegroundColor(null);
                }
                LoggingPreferenceWidget.this.backgroundSelector.setEnabled(isSelected);
                LoggingPreferenceWidget.this.lineHighlightSelector.setEnabled(isSelected);
                LoggingPreferenceWidget.this.selectionForegroundSelector.setEnabled(isSelected);
                LoggingPreferenceWidget.this.selectionBackgroundSelector.setEnabled(isSelected);
                LoggingPreferenceWidget.this.foldingBackgroundSelector.setEnabled(isSelected);
                LoggingPreferenceWidget.this.foldingForegroundSelector.setEnabled(isSelected);
                LoggingPreferenceWidget.this.caretSelector.setEnabled(isSelected);
            }
        });
        Composite buttons = new Composite(inner, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.makeColumnsEqualWidth = true;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.makeColumnsEqualWidth = false;
        Composite bgComp = new Composite(buttons, 0);
        bgComp.setLayout((Layout)gridLayout);
        bgComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        Label bgLabel = new Label(bgComp, 131072);
        bgLabel.setText(Messages.LoggingColorizationWidget_35);
        this.backgroundSelector = new ColorSelector(bgComp);
        this.backgroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LoggingPreferenceWidget.this.provider.setBackgroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite lComp = new Composite(buttons, 0);
        lComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        lComp.setLayout((Layout)gridLayout);
        Label lLabel = new Label(lComp, 131072);
        lLabel.setText(Messages.LoggingColorizationWidget_36);
        this.lineHighlightSelector = new ColorSelector(lComp);
        this.lineHighlightSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LoggingPreferenceWidget.this.provider.setLineHighlightColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite sfComp = new Composite(buttons, 0);
        sfComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        sfComp.setLayout((Layout)gridLayout);
        Label sfLabel = new Label(sfComp, 131072);
        sfLabel.setText(Messages.LoggingColorizationWidget_37);
        this.selectionForegroundSelector = new ColorSelector(sfComp);
        this.selectionForegroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LoggingPreferenceWidget.this.provider.setSelectionForegroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite sbComp = new Composite(buttons, 0);
        sbComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        sbComp.setLayout((Layout)gridLayout);
        Label sbLabel = new Label(sbComp, 131072);
        sbLabel.setText(Messages.LoggingColorizationWidget_38);
        this.selectionBackgroundSelector = new ColorSelector(sbComp);
        this.selectionBackgroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LoggingPreferenceWidget.this.provider.setSelectionBackgroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite fbgComp = new Composite(buttons, 0);
        fbgComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        fbgComp.setLayout((Layout)gridLayout);
        Label fbgLabel = new Label(fbgComp, 131072);
        fbgLabel.setText(Messages.LoggingColorizationWidget_39);
        this.foldingBackgroundSelector = new ColorSelector(fbgComp);
        this.foldingBackgroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LoggingPreferenceWidget.this.provider.setFoldingBackgroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite ffgComp = new Composite(buttons, 0);
        ffgComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        ffgComp.setLayout((Layout)gridLayout);
        Label ffgLabel = new Label(ffgComp, 131072);
        ffgLabel.setText(Messages.LoggingColorizationWidget_40);
        this.foldingForegroundSelector = new ColorSelector(ffgComp);
        this.foldingForegroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LoggingPreferenceWidget.this.provider.setFoldingForegroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite cComp = new Composite(buttons, 0);
        cComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        cComp.setLayout((Layout)gridLayout);
        Label cLabel = new Label(cComp, 131072);
        cLabel.setText(Messages.LoggingColorizationWidget_41);
        this.caretSelector = new ColorSelector(cComp);
        this.caretSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LoggingPreferenceWidget.this.provider.setCaretColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        if (Platform.getOS().equals("macosx")) {
            cComp.setVisible(false);
        }
        this.loadEditorOptions();
        if (this.provider != null) {
            this.viewer.setContentProvider((IContentProvider)this.provider);
            this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
            this.initializeColorizerView();
        }
    }

    private void styleCells() {
        CheckboxCellEditor editor = new CheckboxCellEditor((Composite)this.tree);
        ColorCellEditor colorEditor = new ColorCellEditor((Composite)this.tree);
        CellEditor[] editors = new CellEditor[COLUMNS.length];
        editors[0] = editor;
        editors[1] = null;
        editors[2] = null;
        editors[3] = colorEditor;
        editors[4] = editor;
        editors[5] = editors[4];
        editors[6] = editors[5];
        ICellModifier modifier = new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                ColorizationStyle style = null;
                if (element instanceof IToken) {
                    style = LoggingPreferenceWidget.this.provider.getStyle((IToken)element);
                } else if (element instanceof LanguageStructureProvider.Category) {
                    style = ((LanguageStructureProvider.Category)element).getStyle();
                }
                if (style != null) {
                    if (value instanceof Boolean) {
                        Boolean bool = (Boolean)value;
                        if (element instanceof IToken && property == COLUMNS[0]) {
                            LoggingPreferenceWidget.this.provider.removeStyle((IToken)element);
                        } else if (property == COLUMNS[4]) {
                            style.setBold(bool.booleanValue());
                        } else if (property == COLUMNS[5]) {
                            style.setItalic(bool.booleanValue());
                        } else if (property == COLUMNS[6]) {
                            style.setUnderline(bool.booleanValue());
                        }
                    } else if (value instanceof RGB) {
                        RGB rgb = (RGB)value;
                        if (property == COLUMNS[3]) {
                            style.setForegroundColor(UnifiedColorManager.getInstance().getColor(rgb));
                        }
                    }
                }
                LoggingPreferenceWidget.this.viewer.update(element, null);
            }

            public Object getValue(Object element, String property) {
                ColorizationStyle style = null;
                if (element instanceof IToken) {
                    style = LoggingPreferenceWidget.this.provider.getStyle((IToken)element);
                } else if (element instanceof LanguageStructureProvider.Category) {
                    style = ((LanguageStructureProvider.Category)element).getStyle();
                }
                if (style != null) {
                    if (property == COLUMNS[0]) {
                        return true;
                    }
                    if (property == COLUMNS[3]) {
                        return style.getForegroundColor().getRGB();
                    }
                    if (property == COLUMNS[4]) {
                        return style.isBold();
                    }
                    if (property == COLUMNS[5]) {
                        return style.isItalic();
                    }
                    if (property == COLUMNS[6]) {
                        return style.isUnderline();
                    }
                } else if (property == COLUMNS[0]) {
                    return false;
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                boolean canModify = false;
                ColorizationStyle style = null;
                if (element instanceof IToken) {
                    style = LoggingPreferenceWidget.this.provider.getStyle((IToken)element);
                    if (property == COLUMNS[0]) {
                        canModify = true;
                    }
                } else if (element instanceof LanguageStructureProvider.Category) {
                    style = ((LanguageStructureProvider.Category)element).getStyle();
                }
                if (style != null) {
                    canModify = true;
                }
                return canModify;
            }
        };
        TreeColumn column1 = new TreeColumn(this.tree, 16384);
        column1.setWidth(17);
        column1.setText(COLUMNS[0]);
        TreeColumn column2 = new TreeColumn(this.tree, 16384);
        column2.setWidth(125);
        column2.setText(COLUMNS[1]);
        TreeColumn column3 = new TreeColumn(this.tree, 0x1000000);
        column3.setWidth(17);
        column3.setText(COLUMNS[2]);
        column3.pack();
        TreeColumn column4 = new TreeColumn(this.tree, 0x1000000);
        column4.setWidth(17);
        column4.setText(COLUMNS[3]);
        column4.pack();
        TreeColumn column5 = new TreeColumn(this.tree, 0x1000000);
        column5.setWidth(17);
        column5.setText(COLUMNS[4]);
        column5.pack();
        TreeColumn column6 = new TreeColumn(this.tree, 0x1000000);
        column6.setWidth(17);
        column6.setText(COLUMNS[5]);
        column6.pack();
        TreeColumn column7 = new TreeColumn(this.tree, 0x1000000);
        column7.setWidth(17);
        column7.setText(COLUMNS[6]);
        column7.pack();
        this.viewer.setColumnProperties(COLUMNS);
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier(modifier);
    }

    public void setErrorHandler(IErrorHandler handler) {
        this.errorHandler = handler;
    }

    private boolean regionNameExists(String newName, IToken token) {
        Map regions = this.provider.getRegions(token);
        Iterator iter = regions.values().iterator();
        while (iter.hasNext()) {
            String name = ((Region)iter.next()).getName();
            if (!name.equals(newName)) continue;
            return true;
        }
        return false;
    }

    private void initializeColorizerView() {
        if (this.override != null) {
            this.override.setEnabled(this.provider != null);
        }
        this.importButton.setEnabled(this.provider != null);
        this.exportButton.setEnabled(this.provider != null);
        this.viewer.setInput(INPUT);
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof LanguageStructureProvider.Category) {
                items[i].setBackground(UnifiedColorManager.getInstance().getColor(new RGB(192, 192, 192)));
            }
            ++i;
        }
        if (this.tree.getItemCount() > 0) {
            this.tree.showItem(this.tree.getItem(0));
            this.tree.showColumn(this.tree.getColumn(0));
        }
    }

    private void styleImportExport() {
        Group io = new Group(this.displayArea, 0);
        io.setText(Messages.LoggingColorizationWidget_60);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 2;
        io.setLayout((Layout)layout);
        io.setLayoutData((Object)new GridData(4, 4, true, false));
        this.importButton = new Button((Composite)io, 8);
        this.importButton.setEnabled(false);
        this.importButton.setText(StringUtils.ellipsify((String)Messages.LoggingColorizationWidget_27));
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LoggingPreferenceWidget.this.displayArea.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.col"});
                dialog.setText(Messages.LoggingColorizationWidget_63);
                String path = dialog.open();
                if (path != null) {
                    if (!MessageDialog.openQuestion((Shell)LoggingPlugin.getActiveWorkbenchShell(), (String)Messages.LoggingColorizationWidget_ConfirmRewritingTitle, (String)Messages.LoggingColorizationWidget_ConfirmRewritingCurrentMessage)) {
                        return;
                    }
                    File file = new File(path);
                    LoggingPreferenceWidget.this.provider.importColorization(file);
                    LoggingPreferenceWidget.this.loadEditorOptions();
                    LoggingPreferenceWidget.this.initializeColorizerView();
                }
            }
        });
        this.exportButton = new Button((Composite)io, 8);
        this.exportButton.setEnabled(false);
        this.exportButton.setText(StringUtils.ellipsify((String)Messages.LoggingColorizationWidget_64));
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LoggingPreferenceWidget.this.displayArea.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.col"});
                dialog.setText(Messages.LoggingColorizationWidget_66);
                dialog.setFileName("colorization.col");
                String path = dialog.open();
                if (path != null) {
                    File file = new File(path);
                    if (file.exists() && !MessageDialog.openQuestion((Shell)LoggingPlugin.getActiveWorkbenchShell(), (String)Messages.LoggingColorizationWidget_ConfirmRewritingTitle, (String)Messages.LoggingColorizationWidget_ConfirmRewritingMessage)) {
                        return;
                    }
                    try {
                        LoggingPreferenceWidget.this.provider.buildColorizationFile(file);
                    }
                    catch (LexerException lexerException) {
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.LoggingColorizationWidget_68);
                    }
                }
            }
        });
    }

    public void saveStyles() {
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editors.EXPAND_TOKENS", this.tokenExpandable.isExpanded());
    }

    private void resetWidget() {
        this.setProvider(this.provider);
        this.initializeColorizerView();
        this.loadEditorOptions();
    }

    public void resetToDefaults() {
        TabItem[] selection = this.folder.getSelection();
        if (selection != null && selection.length == 1) {
            TabItem item = selection[0];
            int index = this.folder.indexOf(item);
            if (index == 0) {
                this.provider.restoreGeneralDefaults();
            } else if (index == 1) {
                this.provider.restoreColorizationDefautls();
            } else {
                this.provider.resetToLanguageDefaults();
            }
        } else {
            this.provider.resetToLanguageDefaults();
        }
        this.resetWidget();
    }

    public LoggingStructureProvider getProvider() {
        return this.provider;
    }

    public void setProvider(LoggingStructureProvider provider) {
        if (this.coloringComposite != null) {
            if (provider != null) {
                this.viewer.setContentProvider((IContentProvider)provider);
                this.viewer.setLabelProvider((IBaseLabelProvider)provider);
            } else {
                this.viewer.setContentProvider((IContentProvider)this.nullContentProvider);
                this.viewer.setLabelProvider((IBaseLabelProvider)this.nullLabelProvider);
            }
            this.provider = provider;
            this.initializeColorizerView();
            this.loadEditorOptions();
            this.autoboldingBox.setSelection(provider.getAutoBolding());
            this.wrappingBox.setSelection(provider.getWrapping());
            this.timeoutText.setText(Integer.toString(provider.getReadTimeot()));
            this.bufferText.setText(Integer.toString(provider.getReadBuffer()));
            this.backlogText.setText(Integer.toString(provider.getBacklogLines()));
            this.cursorLineColorSelector.setColorValue(provider.getCursorLineColor());
            this.textForegroundColorSelector.setColorValue(provider.getTextForegroundColor());
            String[] items = this.charsetCombo.getItems();
            String currentValue = provider.getDefaultEncoding();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(currentValue)) {
                    this.charsetCombo.select(i);
                }
                ++i;
            }
            FontData[] font = provider.getFont();
            if (font != null && font.length > 0) {
                String fontStr = String.valueOf(font[0].getName()) + "-" + font[0].getHeight();
                this.fontStyleLabel.setText(fontStr);
            }
        }
    }

    protected void editRule() {
        IToken selected;
        TreeItem[] selection = this.tree.getSelection();
        if (selection != null && selection.length != 0 && (selected = this.getSelectedToken(selection[0])) != null) {
            LoggingPreferences.Rule initialContent = null;
            for (LoggingPreferences.Rule rule : this.provider.getCurrentRules()) {
                if (!rule.getName().equals(selected.getType())) continue;
                initialContent = rule;
            }
            NewRuleDialog dialog = new NewRuleDialog(this.coloringComposite.getShell(), initialContent);
            if (dialog.open() == 0) {
                this.provider.updateRule(selected, dialog.getContent(), dialog.isRegexp(), dialog.isCaseInsensitive());
                this.viewer.refresh();
            }
        }
    }

    protected void removeRule() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection != null && selection.length != 0) {
            IToken selectedToken = this.getSelectedToken(selection[0]);
            if (selectedToken != null) {
                this.provider.removeRule(selectedToken);
            }
            this.viewer.refresh();
        }
    }

    private IToken getSelectedToken(TreeItem selection) {
        IToken token = (IToken)selection.getData();
        return token;
    }

    protected void addRule() {
        NewRuleDialog dialog = new NewRuleDialog(this.coloringComposite.getShell(), null);
        ArrayList<String> forbiddenNames = new ArrayList<String>();
        for (LoggingPreferences.Rule rule : this.provider.getCurrentRules()) {
            forbiddenNames.add(rule.getName());
        }
        dialog.setForbiddenNames(forbiddenNames);
        if (dialog.open() == 0) {
            this.provider.addRuleToBeginning(dialog.getName(), dialog.getContent(), dialog.isRegexp(), dialog.isCaseInsensitive());
            this.viewer.refresh();
        }
    }

    protected void moveRuleDown() {
        IToken selectedToken;
        TreeItem[] selection = this.tree.getSelection();
        if (selection != null && selection.length != 0 && (selectedToken = this.getSelectedToken(selection[0])) != null) {
            this.provider.moveRuleDown(selectedToken);
            this.viewer.refresh();
            TreeItem toSelect = this.getItemByToken(selectedToken);
            if (toSelect != null) {
                this.tree.setSelection(toSelect);
            }
        }
    }

    private void moveRuleUp() {
        IToken selectedToken;
        TreeItem[] selection = this.tree.getSelection();
        if (selection != null && selection.length != 0 && (selectedToken = this.getSelectedToken(selection[0])) != null) {
            this.provider.moveRuleUp(selectedToken);
            this.viewer.refresh();
            TreeItem toSelect = this.getItemByToken(selectedToken);
            if (toSelect != null) {
                this.tree.setSelection(toSelect);
            }
        }
    }

    private TreeItem getItemByToken(IToken token) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = this.tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.provider.tokensEqual((IToken)item.getData(), token)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private LoggingPreferences getPreferences() {
        return LoggingPlugin.getDefault().getLoggingPreferences();
    }
}

