/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml;

import com.aptana.xml.BooleanConverter;
import com.aptana.xml.Bundle;
import com.aptana.xml.BundleClassLoader;
import com.aptana.xml.CharacterConverter;
import com.aptana.xml.DocumentNode;
import com.aptana.xml.DoubleConverter;
import com.aptana.xml.FloatConverter;
import com.aptana.xml.IConverter;
import com.aptana.xml.IErrorHandler;
import com.aptana.xml.INode;
import com.aptana.xml.IntegerConverter;
import com.aptana.xml.Messages;
import com.aptana.xml.NodeBase;
import com.aptana.xml.Package;
import com.aptana.xml.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
extends DefaultHandler {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_CLASS = new HashMap();
    private static final Pattern PARSE_ERROR_LINE_NUMBER = Pattern.compile(" line (\\d+)");
    private String _namespace;
    private List<String> _packages;
    private List<String> _suffixes;
    private Map<Class<?>, IConverter> _convertersByClass;
    private Map<String, Class<?>> _classByName;
    private INode _currentNode;
    private Stack<INode> _nodes;
    private DocumentNode _documentNode;
    private StringBuffer _textBuffer;
    private Locator _locator;
    private Class<?> _unknownElementClass;
    private BundleClassLoader _classLoader;
    private IErrorHandler _errorHandler;
    private boolean _cacheClasses;

    static {
        PRIMITIVE_TO_CLASS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_CLASS.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_CLASS.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_CLASS.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_CLASS.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_CLASS.put(Double.TYPE, Double.class);
    }

    public Parser() {
        this(null);
    }

    public Parser(String namespace) {
        this._namespace = namespace;
        this._packages = new ArrayList<String>();
        this._suffixes = new ArrayList<String>();
        this._convertersByClass = new HashMap();
        this._classByName = new HashMap();
        this._nodes = new Stack();
        this._textBuffer = new StringBuffer();
        this.addConverters();
        this.addPackages();
        this.addSuffixes();
        this._classLoader = new BundleClassLoader();
        this._unknownElementClass = NodeBase.class;
        this._cacheClasses = true;
    }

    public void addBundle(org.osgi.framework.Bundle bundle) {
        if (bundle != null) {
            this._classLoader.addBundle(bundle);
        }
    }

    public void addClass(String name, Class<?> type) {
        this._classByName.put(name, type);
    }

    public void addConverter(Class<?> targetType, IConverter converter) {
        this._convertersByClass.put(targetType, converter);
    }

    protected void addConverters() {
        this.addConverter(Boolean.class, new BooleanConverter());
        this.addConverter(Character.class, new CharacterConverter());
        this.addConverter(Double.class, new DoubleConverter());
        this.addConverter(Float.class, new FloatConverter());
        this.addConverter(Integer.class, new IntegerConverter());
        this.addConverter(Boolean.TYPE, new BooleanConverter());
        this.addConverter(Character.TYPE, new CharacterConverter());
        this.addConverter(Double.TYPE, new DoubleConverter());
        this.addConverter(Float.TYPE, new FloatConverter());
        this.addConverter(Integer.TYPE, new IntegerConverter());
    }

    public void addPackage(String packageName) {
        if (!this._packages.contains(packageName)) {
            this._packages.add(packageName);
        }
    }

    protected void addPackages() {
        java.lang.Package thisPackage = this.getClass().getPackage();
        String packageName = thisPackage.getName();
        this.addPackage(packageName);
    }

    public void addSuffix(String suffix) {
        if (!this._suffixes.contains(suffix)) {
            this._suffixes.add(suffix);
        }
    }

    protected void addSuffixes() {
        this.addSuffix("");
    }

    private void appendText() {
        if (this._currentNode != null) {
            this._currentNode.appendText(this._textBuffer.toString());
        }
        this._textBuffer.setLength(0);
    }

    private void applyAttributes(INode node, Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            Method setter = this.findSetter(node, name);
            if (setter != null) {
                Class<?> parameterType = setter.getParameterTypes()[0];
                if (parameterType.isPrimitive() && PRIMITIVE_TO_CLASS.containsKey(parameterType)) {
                    parameterType = PRIMITIVE_TO_CLASS.get(parameterType);
                }
                if (parameterType == String.class) {
                    try {
                        setter.invoke((Object)node, value);
                    }
                    catch (Exception exception) {
                        String message = MessageFormat.format(Messages.Parser_Error_Invoking_Setter, setter.getName(), name);
                        this.sendError(message);
                    }
                } else {
                    IConverter converter = this.findConverter(parameterType);
                    if (converter != null) {
                        Object ary = Array.newInstance(parameterType, 1);
                        Array.set(ary, 0, converter.fromString(value));
                        try {
                            Object[] argsArray = (Object[])ary;
                            setter.invoke((Object)node, argsArray);
                        }
                        catch (Exception exception) {
                            String message = MessageFormat.format(Messages.Parser_Error_Invoking_Setter, setter.getName(), name);
                            this.sendError(message);
                        }
                    } else {
                        String message = MessageFormat.format(Messages.Parser_No_Converter, parameterType.getName());
                        this.sendError(message);
                    }
                }
            } else {
                String message = MessageFormat.format(Messages.Parser_No_Setter, name);
                this.sendWarning(message);
            }
            ++i;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this._textBuffer.append(ch, start, length);
    }

    protected DocumentNode createDocumentNode() {
        return new DocumentNode();
    }

    @Override
    public void endDocument() throws SAXException {
        this._currentNode = null;
        this._nodes.clear();
        this._textBuffer.setLength(0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.appendText();
        if (this._namespace == null || this._namespace.equals(uri)) {
            if (localName.indexOf(46) == -1) {
                this.exitObject();
            } else {
                this.setProperty(localName);
            }
        }
    }

    private void enterObject(String name, Attributes attributes) throws Exception {
        String className = this.toClassName(name);
        Class<?> nodeClass = this.findClass(className);
        this.appendText();
        try {
            Constructor<?> ctor = nodeClass.getConstructor(new Class[0]);
            INode node = (INode)ctor.newInstance(new Object[0]);
            node.setLineNumber(this._locator.getLineNumber());
            node.setColumnNumber(this._locator.getColumnNumber());
            this.applyAttributes(node, attributes);
            if (this._currentNode != null) {
                this._nodes.push(this._currentNode);
            }
            this._currentNode = node;
        }
        catch (Exception exception) {
            String message = MessageFormat.format(Messages.Parser_Could_Not_Create_Class, nodeClass.getName(), name);
            this.sendError(message);
        }
    }

    private void exitObject() {
        if (this._nodes.size() > 0) {
            if (this._currentNode instanceof Package) {
                String packageName = this._currentNode.getText();
                this.addPackage(packageName);
            } else if (this._currentNode instanceof Bundle) {
                String bundleName = this._currentNode.getText();
                org.osgi.framework.Bundle bundle = Platform.getBundle((String)bundleName);
                if (bundle != null) {
                    this.addBundle(bundle);
                } else {
                    this.sendWarning(String.valueOf(Messages.Parser_Bundle_Not_Found) + bundleName);
                }
            }
            INode parent = this._nodes.pop();
            try {
                if (this._currentNode != null) {
                    parent.appendChild(this._currentNode);
                }
            }
            catch (IllegalArgumentException e) {
                this.sendError(e.getMessage());
            }
            this._currentNode = parent;
        } else {
            this._currentNode = null;
        }
    }

    private Class<?> findClass(String className) {
        Class<?> result;
        if (!this._classByName.containsKey(className)) {
            Class<?> candidate = null;
            int i = 0;
            while (i < this._packages.size()) {
                String pkg = this._packages.get(i);
                String fullClassName = String.valueOf(pkg) + "." + className;
                int j = 0;
                while (j < this._suffixes.size()) {
                    String suffix = this._suffixes.get(j);
                    String extendedName = String.valueOf(fullClassName) + suffix;
                    try {
                        candidate = this._classLoader.loadClass(extendedName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    if (candidate != null) {
                        if (INode.class.isAssignableFrom(candidate)) break;
                        candidate = null;
                    }
                    ++j;
                }
                if (candidate != null) break;
                ++i;
            }
            if (candidate == null) {
                candidate = this._unknownElementClass;
                String message = MessageFormat.format(Messages.Parser_Class_Not_Found_Using_Replacement, className, this._unknownElementClass.getName());
                this.sendError(message);
            }
            if (this._cacheClasses) {
                this.addClass(className, candidate);
            }
            result = candidate;
        } else {
            result = this._classByName.get(className);
        }
        return result;
    }

    private IConverter findConverter(Class<?> parameterType) {
        if (!this._convertersByClass.containsKey(parameterType)) {
            Class<?> candidate = null;
            String converterName = String.valueOf(parameterType.getName()) + "Converter";
            IConverter instance = null;
            int i = 0;
            while (i < this._packages.size()) {
                String pkg = this._packages.get(i);
                String fullConverterName = String.valueOf(pkg) + "." + converterName;
                try {
                    candidate = this._classLoader.loadClass(fullConverterName);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (candidate != null) break;
                ++i;
            }
            if (candidate != null) {
                try {
                    Constructor ctor = candidate.getConstructor(new Class[0]);
                    Object converter = ctor.newInstance(new Object[0]);
                    if (converter instanceof IConverter) {
                        instance = (IConverter)converter;
                    }
                }
                catch (Exception exception) {}
            }
            this.addConverter(parameterType, instance);
        }
        return this._convertersByClass.get(parameterType);
    }

    private Method findSetter(Object object, String name) {
        Method result = null;
        String methodName = this.toMethodName(name);
        Method[] methods = object.getClass().getMethods();
        ArrayList<Method> candidates = new ArrayList<Method>();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (method.getName().equals(methodName) && parameterTypes.length == 1) {
                if (parameterTypes[0] == String.class) {
                    candidates.add(0, method);
                } else {
                    candidates.add(method);
                }
            }
            ++i;
        }
        if (candidates.size() > 0) {
            result = (Method)candidates.get(0);
        }
        return result;
    }

    public boolean cacheClasses() {
        return this._cacheClasses;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Class<?> getUnknownElementClass() {
        return this._unknownElementClass;
    }

    public DocumentNode loadXML(File file) {
        DocumentNode result = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            result = this.loadXML(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return result;
    }

    public DocumentNode loadXML(InputStream in) {
        block14: {
            try {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser saxParser = factory.newSAXParser();
                    saxParser.parse(in, (DefaultHandler)this);
                }
                catch (Exception e) {
                    this.sendError(e.getMessage());
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this._documentNode;
    }

    public void removeBundle(org.osgi.framework.Bundle bundle) {
        if (bundle != null) {
            this._classLoader.removeBundle(bundle);
        }
    }

    public void removeClass(String name) {
        this._classByName.remove(name);
    }

    public void removeConverter(Class<?> targetType) {
        this._convertersByClass.remove(targetType);
    }

    public void removePackage(String packageName) {
        this._packages.remove(packageName);
    }

    public void removeSuffix(String suffix) {
        this._suffixes.remove(suffix);
    }

    private void sendError(String message) {
        if (this._errorHandler != null) {
            int line = this._locator.getLineNumber();
            int column = this._locator.getColumnNumber();
            if (line == -1) {
                Matcher m = PARSE_ERROR_LINE_NUMBER.matcher(message);
                line = m.find() ? Integer.parseInt(m.group(1)) : 1;
            }
            if (column == -1) {
                column = 0;
            }
            this._errorHandler.handleError(line, column, message);
        }
    }

    private void sendWarning(String message) {
        if (this._errorHandler != null) {
            int line = this._locator.getLineNumber();
            int column = this._locator.getColumnNumber();
            if (line == -1) {
                Matcher m = PARSE_ERROR_LINE_NUMBER.matcher(message);
                line = m.find() ? Integer.parseInt(m.group(1)) : 1;
            }
            if (column == -1) {
                column = 0;
            }
            this._errorHandler.handleWarning(line, column, message);
        }
    }

    public void setCacheClasses(boolean value) {
        this._cacheClasses = value;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this._locator = locator;
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    private void setProperty(String localName) {
        int dotIndex = localName.indexOf(46);
        if (this._nodes.size() > 0 && this._currentNode.getChildCount() > 0) {
            INode parent = this._nodes.pop();
            INode value = this._currentNode.getChild(0);
            if (dotIndex < localName.length() - 1) {
                String name = localName.substring(dotIndex + 1);
                String methodName = this.toMethodName(name);
                Method[] methods = parent.getClass().getMethods();
                int i = 0;
                while (i < methods.length) {
                    Class<?> parameterType;
                    Class<?>[] parameterTypes;
                    Method method = methods[i];
                    if (methodName.equals(method.getName()) && (parameterTypes = method.getParameterTypes()).length == 1 && (parameterType = parameterTypes[0]).isInstance(value)) {
                        Object ary = Array.newInstance(parameterType, 1);
                        Array.set(ary, 0, value);
                        try {
                            method.invoke((Object)parent, (Object[])ary);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    ++i;
                }
            }
            this._currentNode = parent;
        } else {
            this._currentNode = null;
        }
    }

    public void setUnknownElementClass(Class<?> elementClass) {
        this._unknownElementClass = elementClass == null || !INode.class.isInstance(elementClass) ? NodeBase.class : elementClass;
    }

    @Override
    public void startDocument() throws SAXException {
        this._documentNode = this.createDocumentNode();
        this._currentNode = this._documentNode;
        this._documentNode.setErrorHandler(this._errorHandler);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this._namespace == null || this._namespace.equals(uri)) {
            try {
                if (localName.indexOf(46) == -1) {
                    this.enterObject(localName, attributes);
                } else {
                    if (this._currentNode != null) {
                        this._nodes.push(this._currentNode);
                    }
                    this._currentNode = new Property();
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private String toClassName(String name) {
        StringBuffer sb = new StringBuffer();
        boolean toUpper = true;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '-') {
                toUpper = true;
            } else if (toUpper) {
                sb.append(Character.toUpperCase(c));
                toUpper = false;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private String toMethodName(String name) {
        StringBuffer sb = new StringBuffer();
        boolean toUpper = true;
        sb.append("set");
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '-') {
                toUpper = true;
            } else if (toUpper) {
                sb.append(Character.toUpperCase(c));
                toUpper = false;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

