/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.nodes;

import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeAttribute;
import com.aptana.ide.parsing.nodes.Messages;

public class ParseNodeAttribute
implements IParseNodeAttribute {
    private IParseNode _parent;
    private String _name;
    private String _value;
    private int _quoteType;

    public ParseNodeAttribute(IParseNode parent, String name, String value) {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.ParseNodeAttribute_Undefined_Parent);
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.ParseNodeAttribute_Undefined_Name);
        }
        if (value == null) {
            throw new IllegalArgumentException(Messages.ParseNodeAttribute_Undefined_Value);
        }
        this._parent = parent;
        this._name = name;
        this._quoteType = 1;
        this._value = value;
    }

    public int getQuoteType() {
        return this._quoteType;
    }

    public void setQuoteType(int quoteType) {
        this._quoteType = quoteType;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException(Messages.ParseNodeAttribute_Undefined_Value);
        }
        this._value = null;
    }

    public IParseNode getParent() {
        return this._parent;
    }

    public String getSource() {
        SourceWriter writer = new SourceWriter();
        this.getSource(writer);
        return writer.toString();
    }

    public void getSource(SourceWriter writer) {
        String quote = "";
        switch (this._quoteType) {
            case 1: {
                quote = "\"";
                break;
            }
            case 2: {
                quote = "'";
                break;
            }
            case 0: {
                break;
            }
        }
        String value = this._value;
        if (value.indexOf(60) != -1) {
            value = value.replaceAll("<", "&lt;");
        }
        if (value.indexOf(34) != -1) {
            value = value.replaceAll("\"", "&quot;");
        }
        if (value.indexOf(39) != -1) {
            value = value.replaceAll("'", "&apos;");
        }
        if (value.indexOf(38) != -1) {
            value = value.replaceAll("&", "&amp;");
        }
        writer.print(this._name).print("=").print(quote).print(value).print(quote);
    }
}

