/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.matcher;

import com.aptana.ide.lexer.DynamicEnumerationMap;
import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.matcher.AbstractLexemeMatcher;
import com.aptana.ide.parsing.matcher.RuleMatcher;
import com.aptana.xml.INode;
import java.util.HashMap;
import java.util.Map;

public class ParserMatcher
extends AbstractLexemeMatcher {
    private String _language;
    private Map<String, INode> _rules;
    private RuleMatcher _firstRule;
    private boolean _sealed;
    private IEnumerationMap _typeIndexMap;

    public void appendChild(INode child) {
        super.appendChild(child);
        if (child != null && child instanceof RuleMatcher) {
            RuleMatcher rule = (RuleMatcher)child;
            String name = rule.getName();
            if (this.getChildCount() == 1) {
                this._firstRule = rule;
            }
            if (this._rules == null) {
                this._rules = new HashMap<String, INode>();
            }
            if (!this._rules.containsKey(name)) {
                this._rules.put(name, child);
            }
        }
    }

    public String getLanguage() {
        return this._language;
    }

    public int getNodeTypeIndex(String name) {
        return this._typeIndexMap.getIntValue(name);
    }

    public RuleMatcher getRuleByName(String name) {
        RuleMatcher result = null;
        if (this._rules != null && this._rules.containsKey(name)) {
            result = (RuleMatcher)this._rules.get(name);
        }
        return result;
    }

    public int match(Lexeme[] lexemes, int offset, int eofOffset) {
        int result = -1;
        if (this._firstRule != null) {
            result = this._firstRule.match(lexemes, offset, eofOffset);
        }
        if (result != -1) {
            this.result = this._firstRule.getParseResults();
        }
        return result;
    }

    public void seal() {
        if (!this._sealed) {
            this._sealed = true;
            this._typeIndexMap = new DynamicEnumerationMap();
            this.addTypesToMap(this._typeIndexMap);
        }
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public void validate() {
    }

    public void addChildTypes() {
        this.addChildType(RuleMatcher.class);
    }
}

