/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.ILexerBuilder;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.LexerPlugin;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherLexer;
import com.aptana.ide.lexer.matcher.MatcherTokenList;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.ide.lexer.matcher.model.IMatcherElement;
import com.aptana.ide.lexer.matcher.model.LexerElement;
import com.aptana.ide.lexer.matcher.model.MatcherElement;
import com.aptana.xml.DocumentNode;
import com.aptana.xml.IErrorHandler;
import com.aptana.xml.INode;
import com.aptana.xml.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public class MatcherLexerBuilder
implements ILexerBuilder,
IErrorHandler {
    private static final String LEXER_NAMESPACE = "http://www.aptana.com/2007/lexer/1.2";
    private static final String ELEMENT_SUFFIX = "Element";
    private static final String MATCHER_SUFFIX = "Matcher";
    private ILexer _lexer = this.createLexer();

    public void addTokenList(ITokenList list) {
        this._lexer.addLanguage(list);
    }

    public ILexer buildLexer() throws LexerException {
        if (this._lexer != null) {
            this._lexer.seal();
        }
        return this._lexer;
    }

    protected ILexer createLexer() {
        return new MatcherLexer();
    }

    public static Parser createLexerParser() {
        Parser parser = new Parser(LEXER_NAMESPACE);
        parser.addPackage(IMatcherElement.class.getPackage().getName());
        parser.addPackage(ITextMatcher.class.getPackage().getName());
        parser.addSuffix(ELEMENT_SUFFIX);
        parser.addSuffix(MATCHER_SUFFIX);
        parser.setUnknownElementClass(MatcherElement.class);
        return parser;
    }

    protected ITokenList createTokenList(String language) {
        return new MatcherTokenList(language);
    }

    public ITokenList getTokens(String language) {
        ITokenList result = null;
        if (this._lexer != null) {
            result = this._lexer.getTokenList(language);
        }
        return result;
    }

    public void loadXML(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            this.loadXML(inputStream);
        }
        catch (FileNotFoundException e) {
            LexerPlugin.logError(Messages.MatcherLexerBuilder_Error_Reading_XML_File, e);
        }
    }

    public void loadXML(InputStream in) {
        block15: {
            try {
                try {
                    INode node;
                    Parser parser = MatcherLexerBuilder.createLexerParser();
                    parser.setErrorHandler(this);
                    DocumentNode result = parser.loadXML(in);
                    if (result != null && (node = result.getRootNode()) != null && node instanceof LexerElement) {
                        LexerElement lexerElement = (LexerElement)node;
                        lexerElement.validate();
                        ITokenList tokenList = lexerElement.getTokenList(parser.getClassLoader());
                        this._lexer.addLanguage(tokenList);
                    }
                }
                catch (Exception e) {
                    LexerPlugin.logError(Messages.MatcherLexerBuilder_Cannot_Build_Lexer, e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadXML(InputStream in, ClassLoader classLoader) {
        block15: {
            try {
                try {
                    INode node;
                    Parser parser = MatcherLexerBuilder.createLexerParser();
                    parser.setErrorHandler(this);
                    DocumentNode result = parser.loadXML(in);
                    if (result != null && (node = result.getRootNode()) != null && node instanceof LexerElement) {
                        LexerElement lexerElement = (LexerElement)node;
                        lexerElement.validate();
                        ITokenList tokenList = lexerElement.getTokenList(classLoader);
                        this._lexer.addLanguage(tokenList);
                    }
                }
                catch (Exception e) {
                    LexerPlugin.logError(Messages.MatcherLexerBuilder_Cannot_Build_Lexer, e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void handleError(int line, int column, String message) {
        String msg = MessageFormat.format(Messages.MatcherLexerBuilder_Error_Message, Integer.toString(line), Integer.toString(column), message);
        LexerPlugin.logError(msg);
    }

    public void handleInfo(int line, int column, String message) {
        String msg = MessageFormat.format(Messages.MatcherLexerBuilder_Info_Message, Integer.toString(line), Integer.toString(column), message);
        LexerPlugin.logInfo(msg);
    }

    public void handleWarning(int line, int column, String message) {
        String msg = MessageFormat.format(Messages.MatcherLexerBuilder_Warning_Message, Integer.toString(line), Integer.toString(column), message);
        LexerPlugin.logWarning(msg);
    }
}

