/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.AbstractLexer;
import com.aptana.ide.lexer.ICodeBasedTokenList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.Range;

public class MatcherLexer
extends AbstractLexer {
    public Range find(String groupName) throws LexerException {
        int startingPosition = this.currentOffset;
        Range result = Range.Empty;
        String currentGroup = this.getGroup();
        this.setGroup(groupName);
        ICodeBasedTokenList tokenList = (ICodeBasedTokenList)this.getCurrentTokenList();
        char[] source = this.source;
        int eof = this.eofOffset;
        int start = this.currentOffset;
        while (start < eof) {
            int position = tokenList.match(source, start, eof);
            if (position != -1 && position >= start) {
                result = new Range(start, position);
                break;
            }
            ++start;
        }
        this.setGroup(currentGroup);
        this.currentOffset = startingPosition;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match() {
        int startingPosition;
        int result = startingPosition = this.currentOffset;
        this.lastMatchedTokenIndex = -1;
        if (this.getCurrentTokenList() instanceof ICodeBasedTokenList) {
            ICodeBasedTokenList tokenList;
            ICodeBasedTokenList iCodeBasedTokenList = tokenList = (ICodeBasedTokenList)this.getCurrentTokenList();
            synchronized (iCodeBasedTokenList) {
                result = tokenList.match(this.source, startingPosition, this.eofOffset);
                if (result != -1 && result >= startingPosition) {
                    this.lastMatchedTokenIndex = tokenList.getLastMatchedTokenIndex();
                }
            }
        }
        return result;
    }

    public char[] getSourceUnsafe() {
        return this.source;
    }
}

