/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.Messages;

public class BalancedCharacterMatcher
extends AbstractTextMatcher {
    private char _startCharacter;
    private char _endCharacter;
    private int _startingCount;
    private boolean _matchEndOfFile;

    public BalancedCharacterMatcher() {
    }

    public BalancedCharacterMatcher(char startCharacter, char endCharacter) {
        this._startCharacter = startCharacter;
        this._endCharacter = endCharacter;
    }

    public void addChildTypes() {
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        map.addUncategorizedMatcher(target);
    }

    public int match(char[] source, int offset, int eofOffset) {
        int result = -1;
        int count = this._startingCount;
        while (offset < eofOffset) {
            char c = source[offset];
            if (c == this._startCharacter) {
                ++count;
            } else if (c == this._endCharacter) {
                --count;
            }
            if (count == 0) {
                result = offset + 1;
                break;
            }
            ++offset;
        }
        if (result == -1 && this._matchEndOfFile && offset == eofOffset) {
            result = eofOffset;
        }
        if (result != -1) {
            this.accept(source, offset, result, this.token);
        }
        return result;
    }

    public void setEndCharacter(String endCharacter) {
        if (endCharacter != null && endCharacter.length() > 0) {
            this._endCharacter = endCharacter.charAt(0);
        }
    }

    public void setStartCharacter(String startCharacter) {
        if (startCharacter != null && startCharacter.length() > 0) {
            this._startCharacter = startCharacter.charAt(0);
        }
    }

    public void setMatchEndOfFile(boolean value) {
        this._matchEndOfFile = value;
    }

    public void setStartingCount(int count) {
        this._startingCount = count;
    }

    protected void validateLocal() {
        super.validateLocal();
        if (this._startCharacter == '\u0000') {
            this.getDocument().sendError(Messages.BalancedCharacterMatcher_Start_Char_Not_Defined, this);
        } else if (this._endCharacter == '\u0000') {
            this.getDocument().sendWarning(Messages.BalancedCharacterMatcher_End_Char_Not_Defined, this);
        }
    }
}

