/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer;

import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.lexer.Messages;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticEnumerationMap
implements IEnumerationMap {
    private static final String[] NO_STRINGS = new String[0];
    private Method _getIntValueMethod;
    private Method _getNameMethod;
    private Method _getNamesMethod;

    public StaticEnumerationMap(Class<?> enumeration) {
        if (enumeration == null) {
            throw new IllegalArgumentException(Messages.StaticEnumerationMap_Enumeration_Class_Not_Defined);
        }
        Method[] methods = enumeration.getMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] paramTypes;
            Method method = methods[i];
            Class<?> returnType = method.getReturnType();
            String name = method.getName();
            if (name.equals("getIntValue")) {
                paramTypes = method.getParameterTypes();
                if (paramTypes.length == 1 && paramTypes[0] == String.class && returnType == Integer.TYPE) {
                    this._getIntValueMethod = method;
                }
            } else if (name.equals("getName")) {
                paramTypes = method.getParameterTypes();
                if (paramTypes.length == 1 && paramTypes[0] == Integer.TYPE && returnType == String.class) {
                    this._getNameMethod = method;
                }
            } else if (name.equals("getNames") && (paramTypes = method.getParameterTypes()).length == 0 && returnType == Array.class) {
                this._getNamesMethod = method;
            }
            ++i;
        }
    }

    @Override
    public int getIntValue(String name) {
        int result = -1;
        if (this._getIntValueMethod != null) {
            try {
                Integer value = (Integer)this._getIntValueMethod.invoke(null, name);
                result = value;
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public String getName(int index) {
        String result = null;
        if (this._getNameMethod != null) {
            try {
                result = (String)this._getNameMethod.invoke(null, new Integer(index));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public String[] getNames() {
        String[] result = NO_STRINGS;
        if (this._getNamesMethod != null) {
            try {
                result = (String[])this._getNamesMethod.invoke(null, new Object[0]);
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

