/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.io;

import com.aptana.ide.io.Messages;
import java.security.InvalidParameterException;

public class SourceWriter {
    private StringBuffer _buffer;
    private String _indentText;
    private String _currentIndent;
    private static final String DEFAULT_NEWLINE = System.getProperty("line.separator");
    private String newLine = DEFAULT_NEWLINE;

    public SourceWriter() {
        this._buffer = new StringBuffer();
        this._indentText = "    ";
        this._currentIndent = "";
    }

    public StringBuffer getBuffer() {
        return this._buffer;
    }

    public String getIndentText() {
        return this._currentIndent;
    }

    public SourceWriter(int initialIndent, String indent, int tabSize) {
        this._buffer = new StringBuffer();
        this._indentText = indent;
        StringBuffer bf = new StringBuffer();
        if (indent.length() == 1 && indent.charAt(0) == '\t') {
            if (tabSize == 0) {
                tabSize = 1;
            }
            int tabCount = initialIndent / tabSize;
            int a = 0;
            while (a < tabCount) {
                bf.append('\t');
                ++a;
            }
            a = 0;
            while (a < initialIndent % tabSize) {
                bf.append(' ');
                ++a;
            }
        } else {
            int a = 0;
            while (a < initialIndent) {
                bf.append(' ');
                ++a;
            }
        }
        this._currentIndent = bf.toString();
    }

    public SourceWriter decreaseIndent() {
        if (this._currentIndent.length() > 0) {
            int currentLength = this._currentIndent.length();
            int indentTextLength = this._indentText.length();
            this._currentIndent = this._currentIndent.substring(0, currentLength - indentTextLength);
        }
        return this;
    }

    public SourceWriter increaseIndent() {
        this._currentIndent = String.valueOf(this._currentIndent) + this._indentText;
        return this;
    }

    public void setCurrentIndentLevel(int level) {
        this._currentIndent = "";
        int i = 0;
        while (i < level) {
            this.increaseIndent();
            ++i;
        }
    }

    public int getIndentLevel() {
        if (this._indentText.length() == 0) {
            return 0;
        }
        return this._currentIndent.length() / this._indentText.length();
    }

    public static String join(String delimiter, String[] items) {
        int length = items.length;
        String result = "";
        if (length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length - 1) {
                sb.append(items[i]).append(delimiter);
                ++i;
            }
            sb.append(items[length - 1]);
            result = sb.toString();
        }
        return result;
    }

    public SourceWriter print(char c) {
        this._buffer.append(c);
        return this;
    }

    public SourceWriter print(String text) {
        this._buffer.append(text);
        return this;
    }

    public int getCurrentIndentationLevel() {
        int pos = 0;
        int a = this._buffer.length() - 1;
        while (a >= 0) {
            char charAt = this._buffer.charAt(a);
            if (charAt == '\n' || charAt == '\r') break;
            ++pos;
            if (!Character.isWhitespace(charAt)) {
                pos = 0;
            }
            --a;
        }
        return pos;
    }

    public String getCurrentIndentationString() {
        int pos = this._buffer.length();
        int startLine = 0;
        int a = this._buffer.length() - 1;
        while (a >= 0) {
            char charAt = this._buffer.charAt(a);
            if (charAt == '\n' || charAt == '\r') {
                startLine = a + 1;
                break;
            }
            if (!Character.isWhitespace(charAt)) {
                pos = a;
            }
            --a;
        }
        if (this._buffer.length() == 0) {
            return "";
        }
        return this._buffer.substring(startLine, pos);
    }

    public int getCurrentIndentLevel() {
        int pos = 0;
        int a = this._buffer.length() - 1;
        while (a >= 0) {
            char charAt = this._buffer.charAt(a);
            if (charAt == '\n' || charAt == '\r') break;
            ++pos;
            --a;
        }
        return pos;
    }

    public SourceWriter printWithIndent(String text) {
        this._buffer.append(this._currentIndent).append(text);
        return this;
    }

    public SourceWriter printIndent() {
        this._buffer.append(this._currentIndent);
        return this;
    }

    public SourceWriter println() {
        this.println("");
        return this;
    }

    public SourceWriter println(String text) {
        this._buffer.append(text).append(this.newLine);
        return this;
    }

    public SourceWriter printlnWithIndent(String text) {
        this._buffer.append(this._currentIndent).append(text).append(this.newLine);
        return this;
    }

    public static char[] splice(char[] source, char[] insertText, int insertOffset, int removeLength) {
        if (insertOffset < 0) {
            throw new InvalidParameterException(String.valueOf(Messages.SourceWriter_Offset_Below_Zero) + insertOffset);
        }
        if (removeLength < 0) {
            throw new InvalidParameterException(String.valueOf(Messages.SourceWriter_Remove_Length_Below_Zero) + removeLength);
        }
        int postRemoveIndex = insertOffset + removeLength;
        int sourceLength = source != null ? source.length : 0;
        if (postRemoveIndex > sourceLength) {
            throw new InvalidParameterException(Messages.SourceWriter_Remove_Beyond_Length);
        }
        int insertLength = insertText != null ? insertText.length : 0;
        char[] result = new char[sourceLength - removeLength + insertLength];
        if (insertOffset > 0) {
            System.arraycopy(source, 0, result, 0, insertOffset);
        }
        if (insertLength > 0) {
            System.arraycopy(insertText, 0, result, insertOffset, insertLength);
        }
        if (insertOffset + removeLength < sourceLength) {
            System.arraycopy(source, postRemoveIndex, result, insertOffset + insertLength, sourceLength - postRemoveIndex);
        }
        return result;
    }

    public String toString() {
        return this._buffer.toString();
    }

    public void setLineDelimeter(String separator) {
        this.newLine = separator;
    }

    public String getLineDelimeter() {
        return this.newLine;
    }

    public String getIndentString() {
        return this._currentIndent;
    }

    public int getLength() {
        return this._buffer.length();
    }
}

