/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import com.aptana.internal.ui.text.spelling.IInvocationContext;
import com.aptana.internal.ui.text.spelling.JavaPluginImages;
import com.aptana.internal.ui.text.spelling.JavaUIMessages;
import com.aptana.internal.ui.text.spelling.SpellCheckEngine;
import com.aptana.internal.ui.text.spelling.SpellingProblemUtils;
import com.aptana.internal.ui.text.spelling.WordCorrectionProposal;
import com.aptana.internal.ui.text.spelling.engine.ISpellCheckEngine;
import com.aptana.internal.ui.text.spelling.engine.ISpellChecker;
import java.text.MessageFormat;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class WordIgnoreProposal
implements ICompletionProposal {
    private final String fWord;
    private final IInvocationContext fContext;

    public WordIgnoreProposal(String word, IInvocationContext context) {
        this.fWord = word;
        this.fContext = context;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker != null) {
            ISourceViewer sourceViewer;
            checker.ignoreWord(this.fWord);
            if (this.fContext instanceof IQuickAssistInvocationContext && (sourceViewer = ((IQuickAssistInvocationContext)this.fContext).getSourceViewer()) != null) {
                SpellingProblemUtils.removeAll(sourceViewer, this.fWord);
            }
        }
    }

    public String getAdditionalProposalInfo() {
        return MessageFormat.format(JavaUIMessages.Spelling_ignore_info, WordCorrectionProposal.getHtmlRepresentation(this.fWord));
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return MessageFormat.format(JavaUIMessages.Spelling_ignore_label, this.fWord);
    }

    public Image getImage() {
        return JavaPluginImages.get(JavaPluginImages.IMG_OBJS_NLS_NEVER_TRANSLATE);
    }

    public final int getRelevance() {
        return -2147483647;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }
}

