/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import com.aptana.internal.ui.text.spelling.WordRanker;

public class UserWordRanker
extends WordRanker {
    WordRanker parentWordRanker;

    public UserWordRanker(WordRanker parentWordRanker) {
        this.parentWordRanker = parentWordRanker;
    }

    public int getRateForWord(String word) {
        Integer i = (Integer)this.wordRates.get(word = word.trim().toLowerCase());
        if (i == null && this.parentWordRanker != null) {
            return this.parentWordRanker.getRateForWord(word);
        }
        if (this.parentWordRanker != null) {
            int k = this.parentWordRanker.getRateForWord(word);
            if (k > -1) {
                return Math.min(i, k);
            }
            return i;
        }
        return -1;
    }

    public void increaseRateForWord(String word) {
        Integer curRank = (Integer)this.wordRates.get(word = word.trim().toLowerCase());
        if (curRank == null) {
            this.wordRates.put(word, this.expectedWordCount * this.raringCoef);
        } else {
            int increment = this.getIncrementValue(curRank);
            if ((curRank = Integer.valueOf(curRank - increment)) < 0) {
                curRank = 5;
            }
            this.wordRates.remove(word);
            this.wordRates.put(word, curRank);
        }
    }

    protected int getIncrementValue(Integer curRank) {
        if (curRank > 8000) {
            return 1000;
        }
        if (curRank > 6000) {
            return 800;
        }
        if (curRank > 4000) {
            return 600;
        }
        if (curRank > 2000) {
            return 400;
        }
        if (curRank > 1000) {
            return 200;
        }
        if (curRank > 500) {
            return 100;
        }
        if (curRank > 200) {
            return 50;
        }
        if (curRank > 100) {
            return 40;
        }
        if (curRank > 50) {
            return 30;
        }
        return 5;
    }
}

