/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;

public class SpellingProblemUtils {
    public static final String TYPE = "org.eclipse.ui.workbench.texteditor.spelling";

    public static void removeAll(ISourceViewer sourceViewer, String word) {
        Assert.isNotNull((Object)sourceViewer);
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        if (model == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        boolean supportsBatchReplace = model instanceof IAnnotationModelExtension;
        ArrayList<Annotation> toBeRemovedAnnotations = new ArrayList<Annotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            boolean doRemove;
            Annotation annotation = (Annotation)iter.next();
            if (!TYPE.equals(annotation.getType())) continue;
            boolean bl = doRemove = word == null;
            if (word == null) {
                doRemove = true;
            } else {
                String annotationWord = null;
                Position pos = model.getPosition(annotation);
                try {
                    annotationWord = document.get(pos.getOffset(), pos.getLength());
                }
                catch (BadLocationException badLocationException) {
                    continue;
                }
                doRemove = word.equals(annotationWord);
            }
            if (!doRemove) continue;
            if (supportsBatchReplace) {
                toBeRemovedAnnotations.add(annotation);
                continue;
            }
            model.removeAnnotation(annotation);
        }
        if (supportsBatchReplace && !toBeRemovedAnnotations.isEmpty()) {
            Annotation[] annotationArray = toBeRemovedAnnotations.toArray(new Annotation[toBeRemovedAnnotations.size()]);
            ((IAnnotationModelExtension)model).replaceAnnotations(annotationArray, null);
        }
    }
}

