/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.ui.text.spelling;

import com.aptana.internal.ui.text.spelling.engine.DefaultSpellChecker;
import com.aptana.internal.ui.text.spelling.engine.ISpellCheckEngine;
import com.aptana.internal.ui.text.spelling.engine.ISpellChecker;
import com.aptana.internal.ui.text.spelling.engine.ISpellDictionary;
import com.aptana.internal.ui.text.spelling.engine.LocaleSensitiveSpellDictionary;
import com.aptana.internal.ui.text.spelling.engine.PersistentSpellDictionary;
import com.aptana.semantic.ui.text.spelling.Activator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener {
    public static final String DICTIONARY_LOCATION = "dicts/";
    private static ISpellCheckEngine fgEngine = null;
    private static Set fgLocalesWithInstalledDictionaries;
    private Set fGlobalDictionaries = new HashSet();
    private ISpellChecker fChecker = null;
    private Map fLocaleDictionaries = new HashMap();
    private ISpellDictionary fUserDictionary = null;

    private static Set getLocalesWithInstalledDictionaries(URL location) {
        String[] fileNames;
        try {
            URL url = FileLocator.toFileURL((URL)location);
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                return Collections.EMPTY_SET;
            }
            fileNames = file.list();
            if (fileNames == null) {
                return Collections.EMPTY_SET;
            }
        }
        catch (IOException ex) {
            Activator.log(ex);
            return Collections.EMPTY_SET;
        }
        HashSet<Locale> localesWithInstalledDictionaries = new HashSet<Locale>();
        int fileNameCount = fileNames.length;
        int i = 0;
        while (i < fileNameCount) {
            String fileName = fileNames[i];
            int localeEnd = fileName.indexOf(".dictionary");
            if (localeEnd > 1) {
                String localeName = fileName.substring(0, localeEnd);
                int languageEnd = localeName.indexOf(95);
                if (languageEnd == -1) {
                    localesWithInstalledDictionaries.add(new Locale(localeName));
                } else if (languageEnd == 2 && localeName.length() == 5) {
                    localesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3)));
                } else if (localeName.length() > 6 && localeName.charAt(5) == '_') {
                    localesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3, 5), localeName.substring(6)));
                }
            }
            ++i;
        }
        return localesWithInstalledDictionaries;
    }

    public static Set getLocalesWithInstalledDictionaries() {
        Enumeration locations;
        if (fgLocalesWithInstalledDictionaries != null) {
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            locations = SpellCheckEngine.getDictionaryLocations();
            if (locations == null) {
                fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (IOException ex) {
            Activator.log(ex);
            fgLocalesWithInstalledDictionaries = Collections.EMPTY_SET;
            return fgLocalesWithInstalledDictionaries;
        }
        fgLocalesWithInstalledDictionaries = new HashSet();
        while (locations.hasMoreElements()) {
            URL location = (URL)locations.nextElement();
            Set locales = SpellCheckEngine.getLocalesWithInstalledDictionaries(location);
            fgLocalesWithInstalledDictionaries.addAll(locales);
        }
        return fgLocalesWithInstalledDictionaries;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public ISpellDictionary findDictionary(Locale locale) {
        ISpellDictionary dictionary = (ISpellDictionary)this.fLocaleDictionaries.get(locale);
        if (dictionary != null) {
            return dictionary;
        }
        String language = locale.getLanguage();
        for (Map.Entry entry : this.fLocaleDictionaries.entrySet()) {
            Locale dictLocale = (Locale)entry.getKey();
            if (!dictLocale.getLanguage().equals(language)) continue;
            return (ISpellDictionary)entry.getValue();
        }
        ISpellDictionary next = (ISpellDictionary)this.fLocaleDictionaries.values().iterator().next();
        return next;
    }

    public static Locale findClosestLocale(Locale locale) {
        if (locale == null || locale.toString().length() == 0) {
            return locale;
        }
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(locale)) {
            return locale;
        }
        String language = locale.getLanguage();
        for (Locale dictLocale : SpellCheckEngine.getLocalesWithInstalledDictionaries()) {
            if (!dictLocale.getLanguage().equals(language)) continue;
            return dictLocale;
        }
        Locale defaultLocale = Locale.US;
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(defaultLocale)) {
            return defaultLocale;
        }
        return null;
    }

    public static Enumeration getDictionaryLocations() throws IOException {
        Activator plugin = Activator.getDefault();
        if (plugin != null) {
            return plugin.getBundle().getResources("/dicts/");
        }
        return null;
    }

    public static final synchronized ISpellCheckEngine getInstance() {
        if (fgEngine == null) {
            fgEngine = new SpellCheckEngine();
        }
        return fgEngine;
    }

    public static final synchronized void shutdownInstance() {
        if (fgEngine != null) {
            fgEngine.shutdown();
            fgEngine = null;
        }
    }

    private SpellCheckEngine() {
        try {
            Locale locale2 = null;
            Enumeration locations = SpellCheckEngine.getDictionaryLocations();
            while (locations != null && locations.hasMoreElements()) {
                URL location = (URL)locations.nextElement();
                for (Locale locale2 : SpellCheckEngine.getLocalesWithInstalledDictionaries(location)) {
                    this.fLocaleDictionaries.put(locale2, new LocaleSensitiveSpellDictionary(locale2, location));
                }
            }
        }
        catch (IOException iOException) {}
        Activator.getSpellingPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public final synchronized ISpellChecker getSpellChecker() throws IllegalStateException {
        if (this.fGlobalDictionaries == null) {
            throw new IllegalStateException("spell checker has been shut down");
        }
        IPreferenceStore store = Activator.getSpellingPreferenceStore();
        Locale locale = this.getCurrentLocale(store);
        if (this.fUserDictionary == null && "".equals(locale.toString())) {
            return null;
        }
        if (this.fChecker != null && this.fChecker.getLocale().equals(locale)) {
            return this.fChecker;
        }
        this.resetSpellChecker();
        this.fChecker = new DefaultSpellChecker(store, locale);
        this.resetUserDictionary();
        for (ISpellDictionary dictionary : this.fGlobalDictionaries) {
            this.fChecker.addDictionary(dictionary);
        }
        ISpellDictionary dictionary = this.findDictionary(this.fChecker.getLocale());
        if (dictionary != null) {
            this.fChecker.addDictionary(dictionary);
        }
        return this.fChecker;
    }

    private Locale getCurrentLocale(IPreferenceStore store) {
        return Locale.getDefault();
    }

    public static Locale convertToLocale(String locale) {
        Locale defaultLocale = SpellCheckEngine.getDefaultLocale();
        if (locale == null || locale.equals(defaultLocale.toString())) {
            return defaultLocale;
        }
        if (locale.length() >= 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        return new Locale("");
    }

    public final synchronized Locale getLocale() {
        if (this.fChecker == null) {
            return null;
        }
        return this.fChecker.getLocale();
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("spelling_locale")) {
            this.resetSpellChecker();
            return;
        }
        if (event.getProperty().equals("spelling_user_dictionary")) {
            this.resetUserDictionary();
            return;
        }
        if (event.getProperty().equals("spelling_user_dictionary_encoding")) {
            this.resetUserDictionary();
            return;
        }
    }

    private synchronized void resetUserDictionary() {
        block10: {
            IPreferenceStore store;
            String filePath;
            if (this.fChecker == null) {
                return;
            }
            if (this.fUserDictionary != null) {
                this.fChecker.removeDictionary(this.fUserDictionary);
                this.fUserDictionary.unload();
                this.fUserDictionary = null;
            }
            if ((filePath = (store = Activator.getSpellingPreferenceStore()).getString("spelling_user_dictionary")).length() > 0) {
                try {
                    File file = new File(filePath);
                    if (!file.exists() && !file.createNewFile()) {
                        return;
                    }
                    URL url = new URL("file", null, filePath);
                    InputStream stream = url.openStream();
                    if (stream == null) break block10;
                    try {
                        this.fUserDictionary = new PersistentSpellDictionary(url);
                        this.fChecker.addDictionary(this.fUserDictionary);
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    public final synchronized void registerGlobalDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.add(dictionary);
        this.resetSpellChecker();
    }

    public final synchronized void registerDictionary(Locale locale, ISpellDictionary dictionary) {
        this.fLocaleDictionaries.put(locale, dictionary);
        this.resetSpellChecker();
    }

    public final synchronized void shutdown() {
        Activator.getSpellingPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ISpellDictionary dictionary2 = null;
        for (ISpellDictionary dictionary2 : this.fGlobalDictionaries) {
            dictionary2.unload();
        }
        this.fGlobalDictionaries = null;
        for (ISpellDictionary dictionary2 : this.fLocaleDictionaries.values()) {
            dictionary2.unload();
        }
        this.fLocaleDictionaries = null;
        this.fUserDictionary = null;
        this.fChecker = null;
    }

    private synchronized void resetSpellChecker() {
        ISpellDictionary dictionary;
        if (this.fChecker != null && (dictionary = (ISpellDictionary)this.fLocaleDictionaries.get(this.fChecker.getLocale())) != null) {
            dictionary.unload();
        }
        this.fChecker = null;
    }

    public final synchronized void unregisterDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.remove(dictionary);
        this.fLocaleDictionaries.values().remove(dictionary);
        dictionary.unload();
        this.resetSpellChecker();
    }
}

