/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search;

import com.aptana.ide.search.AptanaFileSearchPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

final class MatchesContentProvider
implements IStructuredContentProvider {
    private final AptanaFileSearchPage aptanaFileSearchPage;
    private final IContentProvider contentProvider;
    HashMap mmap = new HashMap();

    MatchesContentProvider(AptanaFileSearchPage aptanaFileSearchPage, IContentProvider contentProvider) {
        this.aptanaFileSearchPage = aptanaFileSearchPage;
        this.contentProvider = contentProvider;
    }

    protected Object[] getMathes(AbstractTextSearchResult input, int limit) {
        ArrayList<Match> result = new ArrayList<Match>();
        Object[] elements = input.getElements();
        int b = 0;
        block0: while (b < elements.length) {
            Match[] matches = this.aptanaFileSearchPage.getInput().getMatches(elements[b]);
            this.mmap.put(elements[b], matches);
            int a = 0;
            while (a < matches.length) {
                result.add(matches[a]);
                if (result.size() == limit) break block0;
                ++a;
            }
            ++b;
        }
        return result.toArray();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof AbstractTextSearchResult) {
            return this.getMathes((AbstractTextSearchResult)inputElement, this.getElementLimit());
        }
        return AptanaFileSearchPage.NO_ELEMENTS;
    }

    private int getElementLimit() {
        return this.aptanaFileSearchPage.getElementLimit1();
    }

    public void dispose() {
        this.contentProvider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mmap = new HashMap(1000);
        this.contentProvider.inputChanged(viewer, oldInput, newInput);
    }

    public void elementsChanged(Object[] updatedElements) {
        StructuredViewer viewer2 = this.aptanaFileSearchPage.getViewer();
        TableViewer viewer = (TableViewer)viewer2;
        int elementLimit = this.getElementLimit();
        boolean tableLimited = this.getElementLimit() == -1;
        AbstractTextSearchResult input = this.aptanaFileSearchPage.getInput();
        int i = 0;
        while (i < updatedElements.length) {
            Object element = updatedElements[i];
            Object[] matchs = (Match[])this.mmap.get(element);
            if (matchs == null) {
                matchs = AptanaFileSearchPage.NO_MATCH;
            }
            if (input.getMatchCount(element) > 0) {
                Match[] matches = input.getMatches(element);
                HashSet<Match> set = new HashSet<Match>(Arrays.asList(matches));
                int a = 0;
                while (a < matchs.length) {
                    Object m = matchs[a];
                    if (!set.contains(m)) {
                        viewer.remove(m);
                    } else {
                        set.remove(m);
                    }
                    ++a;
                }
                this.mmap.put(element, matches);
                for (Match name : set) {
                    if (!tableLimited || viewer.getTable().getItemCount() < elementLimit) {
                        viewer.add((Object)name);
                        continue;
                    }
                    break;
                }
            } else {
                viewer.remove(matchs);
            }
            ++i;
        }
    }
}

