/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.model.IJSStackFrame;
import com.aptana.ide.debug.internal.core.model.JSDebugElement;
import com.aptana.ide.debug.internal.core.model.JSDebugTarget;
import com.aptana.ide.debug.internal.core.model.JSDebugThread;
import com.aptana.ide.debug.internal.core.model.JSDebugVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class JSDebugStackFrame
extends JSDebugElement
implements IJSStackFrame {
    private IThread thread;
    private int frameId;
    private String function;
    private String sourceFile;
    private int sourceLine = -1;
    private IVariable[] variables;
    protected long pc;
    protected int scriptTag;

    public JSDebugStackFrame(IDebugTarget target, IThread thread, int frameId, String function, String sourceFile, int sourceLine, long pc, int scriptTag) {
        super(target);
        this.thread = thread;
        this.frameId = frameId;
        this.function = function;
        this.sourceFile = sourceFile;
        this.sourceLine = sourceLine;
        this.pc = pc;
        this.scriptTag = scriptTag;
    }

    public Object getAdapter(Class adapter) {
        if (IJSStackFrame.class == adapter) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public IVariable[] getVariables() throws DebugException {
        this.getVariables0();
        return this.variables != null ? this.variables : new IVariable[]{};
    }

    public boolean hasVariables() throws DebugException {
        this.getVariables0();
        return this.variables != null && this.variables.length > 0;
    }

    public IThread getThread() {
        return this.thread;
    }

    public int getLineNumber() throws DebugException {
        return this.sourceLine;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.function;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.thread.canStepInto() && this.isTopStackFrame();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        if (!this.thread.canStepReturn()) {
            return false;
        }
        Object bottomFrame = null;
        try {
            IStackFrame[] frames = this.thread.getStackFrames();
            if (frames.length > 0) {
                bottomFrame = frames[frames.length - 1];
            }
        }
        catch (DebugException debugException) {}
        return bottomFrame != null && !bottomFrame.equals(this);
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver() || !this.isValid()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.thread.stepOver();
        } else {
            ((JSDebugThread)this.thread).stepToFrame(this);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn() || !this.isValid()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.thread.stepReturn();
        } else {
            IStackFrame[] frames = this.thread.getStackFrames();
            int i = frames.length - 2;
            while (i > 0) {
                if (frames[i].equals(this)) {
                    ((JSDebugThread)this.thread).stepToFrame(frames[i + 1]);
                }
                --i;
            }
        }
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public String getSourceFileName() {
        return this.sourceFile;
    }

    private void getVariables0() throws DebugException {
        if (this.variables != null || !this.isValid()) {
            return;
        }
        this.variables = ((JSDebugTarget)this.getDebugTarget()).loadVariables(StringUtils.format((String)"frame[{0}]", (int)this.frameId));
        int i = 0;
        while (i < this.variables.length) {
            ((JSDebugVariable)this.variables[i]).flags |= 0x80;
            ++i;
        }
    }

    protected int getFrameId() {
        return this.frameId;
    }

    private boolean isTopStackFrame() {
        IStackFrame tos = null;
        try {
            tos = this.thread.getTopStackFrame();
        }
        catch (DebugException debugException) {}
        return tos != null && tos.equals(this);
    }

    public IVariable findVariable(String variableName) throws DebugException {
        IVariable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equals(variableName)) {
                return vars[i];
            }
            ++i;
        }
        return ((JSDebugTarget)this.getDebugTarget()).findVariable(variableName, (IDebugElement)this);
    }

    protected boolean isSameAs(JSDebugStackFrame other) {
        return this.scriptTag == other.scriptTag && this.pc == other.pc && this.sourceLine == other.sourceLine;
    }

    private boolean isValid() {
        return this.frameId >= 0;
    }

    protected void invalidate() {
        this.frameId = -1;
    }

    protected void invalidate(int frameId, int sourceLine, long pc) {
        this.frameId = frameId;
        this.sourceLine = sourceLine;
        this.pc = pc;
        this.variables = null;
    }
}

