/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.xhr.IXHRService;
import com.aptana.ide.debug.internal.core.model.Messages;
import com.aptana.ide.debug.internal.core.model.StreamsProxy;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

public class JSDebugProcess
extends PlatformObject
implements IProcess,
IDebugEventSetListener {
    private static final int MAX_WAIT_FOR_DEATH_ATTEMPTS = 10;
    private static final int TIME_TO_WAIT_FOR_THREAD_DEATH = 500;
    private ILaunch launch;
    private String label;
    private Process process;
    private boolean killProcessOnTerminate;
    private volatile boolean processTerminated;
    private ProcessMonitorThread processMonitorThread;
    private IStreamsProxy streamsProxy;
    private PipedOutputStream out;
    private PipedOutputStream err;
    private IDebugTarget debugTarget;
    private IXHRService xhrService;
    private Map<String, String> fAttributes;

    public JSDebugProcess(ILaunch launch, String label, Map attributes) {
        this(launch, null, false, label, attributes);
    }

    public JSDebugProcess(ILaunch launch, Process process, String label, Map attributes) {
        this(launch, process, true, label, attributes);
    }

    public JSDebugProcess(ILaunch launch, Process process, boolean killProcessOnTerminate, String label, Map attributes) {
        this.launch = launch;
        this.process = process;
        this.killProcessOnTerminate = killProcessOnTerminate;
        this.label = label;
        this.initializeAttributes(attributes);
        this.out = new PipedOutputStream();
        this.err = new PipedOutputStream();
        launch.addProcess((IProcess)this);
        this.fireCreationEvent();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        if (process != null) {
            try {
                process.exitValue();
                this.processTerminated = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
            if (this.processTerminated) {
                this.fireTerminateEvent();
            } else {
                this.processMonitorThread = new ProcessMonitorThread();
                this.processMonitorThread.start();
            }
        }
    }

    private void initializeAttributes(Map attributes) {
        this.setAttribute(IProcess.ATTR_PROCESS_TYPE, "javascript");
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.setAttribute(key, (String)attributes.get(key));
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        if (this.streamsProxy == null) {
            try {
                this.streamsProxy = new StreamsProxy(new PipedInputStream(this.out), new PipedInputStream(this.err));
            }
            catch (IOException e) {
                JSDebugPlugin.log(e);
            }
        }
        return this.streamsProxy;
    }

    public void setAttribute(String key, String value) {
        String origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, String>(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
        this.fireChangeEvent();
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            this.throwDebugException(null);
        }
        if (this.process != null) {
            return this.process.exitValue();
        }
        return -1;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        if (this.process != null) {
            return this.processTerminated;
        }
        IDebugTarget target = this.getDebugTarget();
        if (target != null) {
            return target.isTerminated();
        }
        return false;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            IDebugTarget target = this.getDebugTarget();
            if (target != null) {
                target.terminate();
            }
            this.terminateProcess();
        }
    }

    private void terminateProcess() throws DebugException {
        if (this.process != null && !this.processTerminated && this.killProcessOnTerminate) {
            this.process.destroy();
            int attempts = 0;
            while (attempts < 10) {
                try {
                    this.process.exitValue();
                    this.processTerminated = true;
                    this.processMonitorThread.interrupt();
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++attempts;
                }
            }
            throw new DebugException((IStatus)new Status(4, "com.aptana.ide.debug.core", 5010, Messages.JSDebugProcess_Terminate_Failed, null));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProcess.class) {
            return this;
        }
        if (adapter == IDebugTarget.class) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        if (adapter == IXHRService.class) {
            return this.xhrService;
        }
        return super.getAdapter(adapter);
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireTerminateEvent() {
        if (DebugPlugin.getDefault() != null) {
            this.fireEvent(new DebugEvent((Object)this, 8));
        }
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    protected void throwDebugException(Exception exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "com.aptana.ide.debug.core", 5012, "", (Throwable)exception));
    }

    private void closeStreams() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {}
        try {
            this.err.close();
        }
        catch (IOException iOException) {}
        this.out = null;
        this.err = null;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStream getErrorStream() {
        return this.err;
    }

    protected void setDebugTarget(IDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    private IDebugTarget getDebugTarget() {
        if (this.debugTarget == null) {
            this.debugTarget = this.launch.getDebugTarget();
        }
        return this.debugTarget;
    }

    protected void setXHRService(IXHRService xhrService) {
        this.xhrService = xhrService;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 8: {
                    Object source = event.getSource();
                    if (!source.equals(this.getDebugTarget())) break;
                    this.closeStreams();
                    this.fireTerminateEvent();
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    try {
                        this.terminateProcess();
                        break;
                    }
                    catch (DebugException e) {
                        IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    private class ProcessMonitorThread
    extends Thread {
        public ProcessMonitorThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (!JSDebugProcess.this.processTerminated) {
                try {
                    try {
                        JSDebugProcess.this.process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.interrupted();
                        JSDebugProcess.this.processTerminated = true;
                        JSDebugProcess.this.fireTerminateEvent();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    JSDebugProcess.this.processTerminated = true;
                    JSDebugProcess.this.fireTerminateEvent();
                    throw throwable;
                }
                JSDebugProcess.this.processTerminated = true;
                JSDebugProcess.this.fireTerminateEvent();
            }
        }
    }
}

