/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public final class Util {
    private static final Pattern CHECK_VARIABLE = Pattern.compile("\\A\\w+(?:\\.\\w+)*\\z");

    private Util() {
    }

    public static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception exception) {
            try {
                return URLDecoder.decode(url, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return url;
            }
        }
    }

    public static String fixupURI(String string) {
        URI uri = null;
        try {
            uri = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (uri == null || uri.getScheme() == null) {
            return new File(string).toURI().toString();
        }
        return string;
    }

    public static String encodeData(String data) {
        return data.replaceAll("#", "#0").replaceAll("\\|", "#1").replaceAll("\\*", "#2");
    }

    public static String decodeData(String data) {
        return data.replaceAll("#2", "*").replaceAll("#1", "|").replaceAll("#0", "#");
    }

    public static boolean checkVariable(String variableName) {
        return CHECK_VARIABLE.matcher(variableName).matches();
    }
}

