/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.ILaunchConfigurationConstants;
import com.aptana.ide.debug.core.JSDebugOptionsManager;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.JSLaunchConfigurationDelegate;
import com.aptana.ide.debug.core.Messages;
import com.aptana.ide.debug.internal.core.BrowserUtil;
import com.aptana.ide.debug.internal.core.LocalResourceMapper;
import com.aptana.ide.debug.internal.core.browsers.Firefox;
import com.aptana.ide.debug.internal.core.browsers.InternetExplorer;
import com.aptana.ide.debug.internal.core.model.HttpServerProcess;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IHttpServerProviderAdapter;
import com.aptana.ide.server.core.IServer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public final class JSLaunchConfigurationHelper {
    public static final String FIREFOX = "Firefox";
    public static final String INTERNET_EXPLORER = "Internet Explorer";
    public static final String SAFARI = "Safari";

    private JSLaunchConfigurationHelper() {
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy configuration, String nature) {
        JSLaunchConfigurationHelper.setBrowserDefaults(configuration, nature);
        JSLaunchConfigurationHelper.setServerDefaults(configuration);
        JSLaunchConfigurationHelper.setHttpDefaults(configuration);
        JSLaunchConfigurationHelper.setDebugDefaults(configuration);
        JSLaunchConfigurationHelper.setAdvancedDefaults(configuration);
    }

    public static void setBrowserDefaults(ILaunchConfigurationWorkingCopy configuration, String nature) {
        String browser;
        block19: {
            Enumeration enumeration;
            block20: {
                File file;
                String location;
                int i;
                String[] locations;
                block21: {
                    String path;
                    block22: {
                        block17: {
                            block18: {
                                browser = "";
                                if (nature == null) {
                                    try {
                                        nature = configuration.getAttribute("browserNature", null);
                                    }
                                    catch (CoreException coreException) {}
                                }
                                if (!"win32".equals(Platform.getOS())) break block17;
                                if (!FIREFOX.equals(nature) && nature != null) break block18;
                                locations = ILaunchConfigurationConstants.DEFAULT_BROWSER_WINDOWS_FIREFOX;
                                i = 0;
                                while (i < locations.length) {
                                    location = PlatformUtils.expandEnvironmentStrings((String)locations[i]);
                                    file = new File(location);
                                    if (file.exists() && !file.isDirectory()) {
                                        browser = location;
                                        break;
                                    }
                                    ++i;
                                }
                                if (browser.length() != 0) break block19;
                            }
                            if (!INTERNET_EXPLORER.equals(nature) && nature != null || !new File(path = PlatformUtils.expandEnvironmentStrings((String)"%ProgramFiles%\\Internet Explorer\\iexplore.exe")).exists()) break block20;
                            browser = path;
                            break block19;
                        }
                        if (!"macosx".equals(Platform.getOS())) break block21;
                        if (!FIREFOX.equals(nature) && nature != null) break block22;
                        locations = ILaunchConfigurationConstants.DEFAULT_BROWSER_MACOSX_FIREFOX;
                        i = 0;
                        while (i < locations.length) {
                            location = PlatformUtils.expandEnvironmentStrings((String)locations[i]);
                            file = new File(location);
                            if (file.exists() && file.isDirectory()) {
                                browser = location;
                                break;
                            }
                            ++i;
                        }
                        if (browser.length() != 0) break block19;
                    }
                    if (!SAFARI.equals(nature) && nature != null || !new File(path = "/Applications/Safari.app").exists()) break block20;
                    browser = path;
                    break block19;
                }
                if (!"linux".equals(Platform.getOS()) || !FIREFOX.equals(nature) && nature != null) break block20;
                locations = ILaunchConfigurationConstants.DEFAULT_BROWSER_LINUX_FIREFOX;
                i = 0;
                while (i < locations.length) {
                    location = PlatformUtils.expandEnvironmentStrings((String)locations[i]);
                    file = new File(location);
                    if (file.exists() && file.isFile()) {
                        browser = location;
                        break;
                    }
                    ++i;
                }
                if (browser.length() != 0) break block19;
            }
            if ((enumeration = (Enumeration)new JSLaunchConfigurationHelper().getContributedAdapter(Enumeration.class)) != null) {
                while (enumeration.hasMoreElements()) {
                    String path = (String)enumeration.nextElement();
                    if ((FIREFOX.equals(nature) || nature == null) && Firefox.isBrowserExecutable(path)) {
                        browser = path;
                        break;
                    }
                    if ((INTERNET_EXPLORER.equals(nature) || nature == null) && InternetExplorer.isBrowserExecutable(path)) {
                        browser = path;
                        break;
                    }
                    if (!SAFARI.equals(nature) && nature != null || path.toLowerCase().indexOf("safari") == -1) continue;
                    browser = path;
                    break;
                }
            }
        }
        configuration.setAttribute("browserExecutable", browser);
        if (nature != null) {
            configuration.setAttribute("browserNature", nature);
        }
    }

    public static void setServerDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("startActionType", 1);
        configuration.setAttribute("serverType", 1);
        configuration.setAttribute("startPagePath", "");
        configuration.setAttribute("startPageUrl", "");
        configuration.setAttribute("externalBaseUrl", "");
        configuration.setAttribute("appendProjectName", false);
    }

    public static void setDebugDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Preferences store = JSDebugPlugin.getDefault().getPluginPreferences();
        configuration.setAttribute("overrideDebugPreferences", false);
        configuration.setAttribute("suspendOnFirstLine", store.getBoolean("com.aptana.ide.debug.core.suspend_on_first_line"));
        configuration.setAttribute("suspendOnExceptions", store.getBoolean("com.aptana.ide.debug.core.suspend_on_exceptions"));
        configuration.setAttribute("suspendOnErrors", store.getBoolean("com.aptana.ide.debug.core.suspend_on_errors"));
        configuration.setAttribute("suspendOnDebuggerKeywords", store.getBoolean("com.aptana.ide.debug.core.suspend_on_debugger_keyword"));
    }

    public static void setAdvancedDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("advancedRunEnabled", false);
    }

    public static void setHttpDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("httpGetData", "");
        configuration.setAttribute("httpPostData", "");
        configuration.setAttribute("httpPostContentType", "");
    }

    public static boolean isBrowserDebugCompatible(String browser) {
        if (browser != null && BrowserUtil.isBrowserDebugCompatible(browser)) {
            return new File(browser).exists();
        }
        return false;
    }

    private static Object getContributedAdapter(Object object, Class clazz) {
        Object adapter = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (manager.hasAdapter(object, clazz.getName()) && (adapter = manager.getAdapter(object, clazz.getName())) == null) {
            adapter = manager.loadAdapter(object, clazz.getName());
        }
        return adapter;
    }

    private Object getContributedAdapter(Class clazz) {
        return JSLaunchConfigurationHelper.getContributedAdapter(this, clazz);
    }

    public static URL getBaseURL(ILaunchConfiguration configuration, IResource resource) throws CoreException {
        int serverType = configuration.getAttribute("serverType", 1);
        int startActionType = configuration.getAttribute("startActionType", 1);
        boolean appendProjectName = configuration.getAttribute("appendProjectName", false);
        URL baseURL = null;
        try {
            IServer server;
            IHttpServerProviderAdapter httpServerProvider;
            if (serverType == 2 || serverType == 3) {
                String externalBaseUrl;
                if (serverType == 2) {
                    externalBaseUrl = configuration.getAttribute("externalBaseUrl", "").trim();
                } else {
                    String serverId = configuration.getAttribute("serverName", null);
                    String host = null;
                    IServer server2 = ServerCore.getServerManager().findServer(serverId);
                    if (server2 != null && (host = server2.getHost()) == null) {
                        host = "localhost";
                    }
                    if (host == null) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationHelper_Host_Not_Specified, null));
                    }
                    externalBaseUrl = StringUtils.format((String)"http://{0}/", (String)host);
                }
                if (externalBaseUrl.length() == 0) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationHelper_Empty_Server_URL, null));
                }
                if (externalBaseUrl.charAt(externalBaseUrl.length() - 1) != '/') {
                    externalBaseUrl = String.valueOf(externalBaseUrl) + '/';
                }
                baseURL = new URL(externalBaseUrl);
            } else if (serverType == 1 && startActionType != 3 && resource != null && (httpServerProvider = (IHttpServerProviderAdapter)JSLaunchConfigurationHelper.getContributedAdapter((Object)new JSLaunchConfigurationDelegate(), IHttpServerProviderAdapter.class)) != null && (server = httpServerProvider.getServer(resource)) != null) {
                baseURL = new URL(StringUtils.format((String)"http://{0}/", (String)server.getHost()));
                IPath documentRoot = server.getDocumentRoot();
                if (documentRoot != null && documentRoot.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
                    appendProjectName = true;
                }
            }
            if (baseURL != null && appendProjectName) {
                IProject project = resource.getProject();
                baseURL = new URL(baseURL, String.valueOf(project.getName()) + '/');
            }
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationHelper_Malformed_URL, (Throwable)e));
        }
        return baseURL;
    }

    public static URL getLaunchURL(ILaunchConfiguration configuration, IResource resource) throws CoreException {
        int startActionType = configuration.getAttribute("startActionType", 1);
        URL launchURL = null;
        try {
            String httpGetQuery;
            if (startActionType == 3) {
                launchURL = new URL(configuration.getAttribute("startPageUrl", ""));
                resource = null;
            } else if (startActionType == 2) {
                String resourcePath = configuration.getAttribute("startPagePath", null);
                resource = resourcePath != null && resourcePath.length() > 0 ? ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(resourcePath)) : null;
            }
            if (resource != null) {
                URL baseURL = JSLaunchConfigurationHelper.getBaseURL(configuration, resource);
                if (baseURL != null) {
                    LocalResourceMapper resourceMapper = new LocalResourceMapper();
                    IPath location = resource.getProject().getLocation();
                    if (location == null) {
                        location = resource.getWorkspace().getRoot().getLocation().append(resource.getProject().getFullPath());
                    }
                    resourceMapper.addMapping(baseURL, location.toFile());
                    JSLaunchConfigurationHelper.setResourceMapping(configuration, baseURL, resourceMapper, null);
                    URI locationURI = resource.getLocationURI();
                    if (locationURI == null) {
                        locationURI = resource.getWorkspace().getRoot().getLocation().append(resource.getFullPath()).toFile().toURI();
                    }
                    launchURL = resourceMapper.resolveLocalURI(locationURI).toURL();
                } else {
                    IPath location = resource.getLocation();
                    if (location == null) {
                        location = resource.getWorkspace().getRoot().getLocation().append(resource.getFullPath());
                    }
                    launchURL = location.toFile().toURI().toURL();
                }
            }
            if (launchURL != null && (httpGetQuery = configuration.getAttribute("httpGetData", "")) != null && httpGetQuery.length() > 0 && launchURL.getQuery() == null && launchURL.getRef() == null) {
                if (httpGetQuery.charAt(0) != '?') {
                    httpGetQuery = String.valueOf('?') + httpGetQuery;
                }
                launchURL = new URL(launchURL, String.valueOf(launchURL.getFile()) + httpGetQuery);
            }
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationHelper_Malformed_URL, (Throwable)e));
        }
        return launchURL;
    }

    public static void initializeLaunchAttributes(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        if (configuration.getAttribute("overrideDebugPreferences", false)) {
            launch.setAttribute("suspendOnFirstLine", Boolean.toString(configuration.getAttribute("suspendOnFirstLine", false)));
            launch.setAttribute("suspendOnExceptions", Boolean.toString(configuration.getAttribute("suspendOnExceptions", false)));
            launch.setAttribute("suspendOnErrors", Boolean.toString(configuration.getAttribute("suspendOnErrors", false)));
            launch.setAttribute("suspendOnDebuggerKeywords", Boolean.toString(configuration.getAttribute("suspendOnDebuggerKeywords", false)));
        } else {
            Preferences store = JSDebugPlugin.getDefault().getPluginPreferences();
            launch.setAttribute("suspendOnFirstLine", Boolean.toString(store.getBoolean("com.aptana.ide.debug.core.suspend_on_first_line")));
            launch.setAttribute("suspendOnExceptions", Boolean.toString(store.getBoolean("com.aptana.ide.debug.core.suspend_on_exceptions")));
            launch.setAttribute("suspendOnErrors", Boolean.toString(store.getBoolean("com.aptana.ide.debug.core.suspend_on_errors")));
            launch.setAttribute("suspendOnDebuggerKeywords", Boolean.toString(store.getBoolean("com.aptana.ide.debug.core.suspend_on_debugger_keyword")));
        }
    }

    static void setResourceMapping(ILaunchConfiguration configuration, URL baseURL, LocalResourceMapper resourceMapper, HttpServerProcess server) throws CoreException {
        String[] list = JSDebugOptionsManager.parseList(configuration.getAttribute("pathsMapping", ""));
        int i = 0;
        int length = list.length;
        while (i < length) {
            boolean enabled;
            String serverPath = list[i++];
            String workspacePath = list[i++];
            boolean bl = enabled = !"0".equals(list[i++]);
            if (!enabled) continue;
            try {
                URL url = new URL(baseURL, new Path(serverPath).makeRelative().toPortableString());
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(workspacePath));
                if (resource == null) continue;
                File file = resource.getLocation().toFile();
                resourceMapper.addMapping(url, file);
                if (server == null) continue;
                server.addServerPath(baseURL.toURI().relativize(url.toURI()).toASCIIString(), file);
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
        }
    }
}

