/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core;

import com.aptana.ide.debug.core.IEditorOpenAdapter;
import com.aptana.ide.debug.core.JSDebugOptionsManager;
import com.aptana.ide.debug.internal.core.UniformResourceBreakpointChangeNotifier;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class JSDebugPlugin
extends Plugin {
    public static final String ID = "com.aptana.ide.debug.core";
    private static JSDebugPlugin plugin;
    private UniformResourceBreakpointChangeNotifier breakpointHelper;

    public JSDebugPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        JSDebugOptionsManager.getDefault().startup();
        this.breakpointHelper = new UniformResourceBreakpointChangeNotifier();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        JSDebugOptionsManager.getDefault().shutdown();
        this.breakpointHelper.cleanup();
        plugin = null;
    }

    public static JSDebugPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        JSDebugPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, ID, 5013, "Error logged from Debug Core: ", t);
        JSDebugPlugin.log((IStatus)status);
    }

    public void openInEditor(Object sourceElement) {
        IEditorOpenAdapter adapter = (IEditorOpenAdapter)this.getContributedAdapter(IEditorOpenAdapter.class);
        if (adapter != null) {
            adapter.openInEditor(sourceElement);
        }
    }

    private Object getContributedAdapter(Class clazz) {
        Object adapter = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (manager.hasAdapter((Object)this, clazz.getName()) && (adapter = manager.getAdapter((Object)this, clazz.getName())) == null) {
            adapter = manager.loadAdapter((Object)this, clazz.getName());
        }
        return adapter;
    }
}

